/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.config.model.mqtt;

import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.protobuf.Struct;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.starter.config.model.mqtt.listener.TCPListenerConfig;
import org.apache.bifromq.starter.config.model.mqtt.listener.TLSListenerConfig;
import org.apache.bifromq.starter.config.model.mqtt.listener.WSListenerConfig;
import org.apache.bifromq.starter.config.model.mqtt.listener.WSSListenerConfig;
import org.apache.bifromq.starter.config.model.serde.StructMapDeserializer;
import org.apache.bifromq.starter.config.model.serde.StructMapSerializer;

public class MQTTServerConfig {
    private boolean enable = true;
    private int connTimeoutSec = 20;
    private int maxConnPerSec = 2000;
    private int maxDisconnPerSec = 1000;
    private int maxMsgByteSize = 262144;
    private int maxConnBandwidth = 524288;
    private int bossELGThreads = 1;
    private int workerELGThreads = Math.max(2, EnvProvider.INSTANCE.availableProcessors() / 2);
    @JsonSerialize(using=StructMapSerializer.class)
    @JsonDeserialize(using=StructMapDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Struct> userPropsCustomizerFactoryConfig = new HashMap<String, Struct>();
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonMerge
    private TCPListenerConfig tcpListener = new TCPListenerConfig();
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonMerge
    private TLSListenerConfig tlsListener = new TLSListenerConfig();
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonMerge
    private WSListenerConfig wsListener = new WSListenerConfig();
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonMerge
    private WSSListenerConfig wssListener = new WSSListenerConfig();

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public int getConnTimeoutSec() {
        return this.connTimeoutSec;
    }

    @Generated
    public int getMaxConnPerSec() {
        return this.maxConnPerSec;
    }

    @Generated
    public int getMaxDisconnPerSec() {
        return this.maxDisconnPerSec;
    }

    @Generated
    public int getMaxMsgByteSize() {
        return this.maxMsgByteSize;
    }

    @Generated
    public int getMaxConnBandwidth() {
        return this.maxConnBandwidth;
    }

    @Generated
    public int getBossELGThreads() {
        return this.bossELGThreads;
    }

    @Generated
    public int getWorkerELGThreads() {
        return this.workerELGThreads;
    }

    @Generated
    public Map<String, Struct> getUserPropsCustomizerFactoryConfig() {
        return this.userPropsCustomizerFactoryConfig;
    }

    @Generated
    public TCPListenerConfig getTcpListener() {
        return this.tcpListener;
    }

    @Generated
    public TLSListenerConfig getTlsListener() {
        return this.tlsListener;
    }

    @Generated
    public WSListenerConfig getWsListener() {
        return this.wsListener;
    }

    @Generated
    public WSSListenerConfig getWssListener() {
        return this.wssListener;
    }

    @Generated
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setConnTimeoutSec(int connTimeoutSec) {
        this.connTimeoutSec = connTimeoutSec;
    }

    @Generated
    public void setMaxConnPerSec(int maxConnPerSec) {
        this.maxConnPerSec = maxConnPerSec;
    }

    @Generated
    public void setMaxDisconnPerSec(int maxDisconnPerSec) {
        this.maxDisconnPerSec = maxDisconnPerSec;
    }

    @Generated
    public void setMaxMsgByteSize(int maxMsgByteSize) {
        this.maxMsgByteSize = maxMsgByteSize;
    }

    @Generated
    public void setMaxConnBandwidth(int maxConnBandwidth) {
        this.maxConnBandwidth = maxConnBandwidth;
    }

    @Generated
    public void setBossELGThreads(int bossELGThreads) {
        this.bossELGThreads = bossELGThreads;
    }

    @Generated
    public void setWorkerELGThreads(int workerELGThreads) {
        this.workerELGThreads = workerELGThreads;
    }

    @JsonDeserialize(using=StructMapDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setUserPropsCustomizerFactoryConfig(Map<String, Struct> userPropsCustomizerFactoryConfig) {
        this.userPropsCustomizerFactoryConfig = userPropsCustomizerFactoryConfig;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setTcpListener(TCPListenerConfig tcpListener) {
        this.tcpListener = tcpListener;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setTlsListener(TLSListenerConfig tlsListener) {
        this.tlsListener = tlsListener;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setWsListener(WSListenerConfig wsListener) {
        this.wsListener = wsListener;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setWssListener(WSSListenerConfig wssListener) {
        this.wssListener = wssListener;
    }
}

