/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.task;

import com.alipay.sofa.registry.client.api.Register;

public class TaskEvent
implements Comparable<TaskEvent> {
    private static final int MAX_DELAY_TIME = 1000;
    private Register source;
    private int sendCount;
    private long triggerTime;

    public TaskEvent(Register source) {
        this.source = source;
        this.triggerTime = System.currentTimeMillis();
        this.sendCount = 0;
    }

    public Register getSource() {
        return this.source;
    }

    public void setTriggerTime(long triggerTime) {
        this.triggerTime = triggerTime;
    }

    public long delayTime() {
        int time = this.sendCount * 200;
        if (time > 1000) {
            time = 1000;
        }
        return (long)time - (System.currentTimeMillis() - this.triggerTime);
    }

    @Override
    public int compareTo(TaskEvent event) {
        long t2;
        if (this.sendCount > event.sendCount) {
            return 1;
        }
        if (this.sendCount < event.sendCount) {
            return -1;
        }
        Register register1 = this.source;
        Register register2 = event.getSource();
        if (register1 == null) {
            return register2 != null ? -1 : 0;
        }
        if (register2 == null) {
            return 1;
        }
        long t1 = register1.getTimestamp();
        if (t1 > (t2 = register2.getTimestamp())) {
            return 1;
        }
        if (t1 < t2) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskEvent)) {
            return false;
        }
        TaskEvent taskEvent = (TaskEvent)o;
        if (this.sendCount != taskEvent.sendCount) {
            return false;
        }
        if (this.triggerTime != taskEvent.triggerTime) {
            return false;
        }
        return this.source != null ? this.source.equals(taskEvent.source) : taskEvent.source == null;
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + this.sendCount;
        result = 31 * result + (int)(this.triggerTime ^ this.triggerTime >>> 32);
        return result;
    }

    public int incSendCount() {
        return this.sendCount++;
    }
}

