/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.annotation.spring.scan;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractMcpAnnotatedBeans;
import org.springframework.ai.mcp.annotation.spring.scan.AnnotatedMethodDiscovery;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.Assert;

public abstract class AbstractAnnotatedMethodBeanPostProcessor
extends AnnotatedMethodDiscovery
implements BeanPostProcessor {
    private final AbstractMcpAnnotatedBeans registry;

    public AbstractAnnotatedMethodBeanPostProcessor(AbstractMcpAnnotatedBeans registry, Set<Class<? extends Annotation>> targetAnnotations) {
        super(targetAnnotations);
        Assert.notNull((Object)registry, (String)"AnnotatedBeanRegistry must not be null");
        Assert.notEmpty(targetAnnotations, (String)"Target annotations must not be empty");
        this.registry = registry;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        Set<Class<? extends Annotation>> foundAnnotations = this.scan(beanClass);
        if (!foundAnnotations.isEmpty()) {
            this.registry.addMcpAnnotatedBean(bean, foundAnnotations);
        }
        return bean;
    }
}

