/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.Map;
import org.apache.fory.Fory;
import org.apache.fory.collection.MapSnapshot;
import org.apache.fory.collection.ObjectArray;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.collection.MapSerializer;

public class ConcurrentMapSerializer<T extends Map>
extends MapSerializer<T> {
    protected final ObjectArray<MapSnapshot> snapshots = new ObjectArray(1);

    public ConcurrentMapSerializer(Fory fory, Class<T> type, boolean supportCodegen) {
        super(fory, type, supportCodegen);
    }

    @Override
    public MapSnapshot onMapWrite(MemoryBuffer buffer, T value) {
        MapSnapshot snapshot = this.snapshots.popOrNull();
        if (snapshot == null) {
            snapshot = new MapSnapshot();
        }
        snapshot.setMap(value);
        buffer.writeVarUint32Small7(snapshot.size());
        return snapshot;
    }

    @Override
    public void onMapWriteFinish(Map map) {
        MapSnapshot snapshot = (MapSnapshot)map;
        snapshot.clear();
        this.snapshots.add(snapshot);
    }
}

