/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry.zk;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.CuratorCacheListenerBuilder;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.exception.ConfigNotFoundException;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegisterServiceImpl
implements RegistryService<CuratorCacheListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperRegisterServiceImpl.class);
    static final Charset CHARSET = StandardCharsets.UTF_8;
    private static volatile ZookeeperRegisterServiceImpl instance;
    private static volatile CuratorFramework zkClient;
    private static final Configuration FILE_CONFIG;
    private static final String ZK_PATH_SPLIT_CHAR = "/";
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String REGISTRY_TYPE = "zk";
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String SESSION_TIME_OUT_KEY = "sessionTimeout";
    private static final String CONNECT_TIME_OUT_KEY = "connectTimeout";
    private static final int DEFAULT_SESSION_TIMEOUT = 6000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.zk.";
    private static final String ROOT_PATH = "/registry/zk/";
    private static final String ROOT_PATH_WITHOUT_SUFFIX = "/registry/zk";
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP;
    private static final ConcurrentMap<String, List<CuratorCacheListener>> LISTENER_SERVICE_MAP;
    private static final ConcurrentMap<String, Object> CLUSTER_LOCK;
    private static Map<String, CuratorCache> nodeCacheMap;
    private static final int REGISTERED_PATH_SET_SIZE = 1;
    private static final Set<String> REGISTERED_PATH_SET;
    private String transactionServiceGroup;

    private ZookeeperRegisterServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ZookeeperRegisterServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<ZookeeperRegisterServiceImpl> clazz = ZookeeperRegisterServiceImpl.class;
        synchronized (ZookeeperRegisterServiceImpl.class) {
            if (instance != null) return instance;
            instance = new ZookeeperRegisterServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        String path = this.getRegisterPathByPath(address);
        this.doRegister(path);
    }

    private boolean doRegister(String path) {
        if (this.checkExists(path)) {
            return false;
        }
        this.createParentIfNotPresent(path);
        this.createEphemeral(path, Boolean.TRUE.toString());
        REGISTERED_PATH_SET.add(path);
        return true;
    }

    private void createParentIfNotPresent(String path) {
        String parent;
        int i = path.lastIndexOf(47);
        if (i > 0 && !this.checkExists(parent = path.substring(0, i))) {
            this.createPersistent(parent);
        }
    }

    private boolean checkExists(String path) {
        try {
            if (this.getClientInstance().checkExists().forPath(path) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        String path = this.getRegisterPathByPath(address);
        this.deletePath(path);
        REGISTERED_PATH_SET.remove(path);
    }

    public void subscribe(String cluster, CuratorCacheListener listener) throws Exception {
        if (cluster == null) {
            return;
        }
        String path = ROOT_PATH + cluster;
        if (!this.checkExists(path)) {
            this.createPersistent(path);
        }
        this.subscribeChildChanges(path, listener);
        LISTENER_SERVICE_MAP.computeIfAbsent(cluster, key -> new CopyOnWriteArrayList()).add(listener);
    }

    private void subscribeChildChanges(String path, CuratorCacheListener listener) {
        CuratorCache nodeCache = CuratorCache.build((CuratorFramework)zkClient, (String)path, (CuratorCache.Options[])new CuratorCache.Options[0]);
        if (nodeCacheMap.putIfAbsent(path, nodeCache) != null) {
            return;
        }
        nodeCache.listenable().addListener((Object)listener);
        nodeCache.start();
    }

    private void unsubscribeChildChanges(String path, CuratorCacheListener listener) {
        CuratorCache nodeCache = nodeCacheMap.get(path);
        if (nodeCache != null) {
            nodeCache.listenable().removeListener((Object)listener);
        }
    }

    public void unsubscribe(String cluster, CuratorCacheListener listener) throws Exception {
        if (cluster == null) {
            return;
        }
        String path = ROOT_PATH + cluster;
        if (this.checkExists(path)) {
            this.unsubscribeChildChanges(path, listener);
            List subscribeList = (List)LISTENER_SERVICE_MAP.get(cluster);
            if (subscribeList != null) {
                List newSubscribeList = subscribeList.stream().filter(eventListener -> !eventListener.equals((Object)listener)).collect(Collectors.toList());
                LISTENER_SERVICE_MAP.put(cluster, newSubscribeList);
            }
        }
    }

    public List<InetSocketAddress> lookup(String key) throws Exception {
        this.transactionServiceGroup = key;
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            String missingDataId = "service.vgroupMapping." + key;
            throw new ConfigNotFoundException("%s configuration item is required", new String[]{missingDataId});
        }
        return this.doLookup(clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<InetSocketAddress> doLookup(String clusterName) throws Exception {
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            Object lock = CLUSTER_LOCK.putIfAbsent(clusterName, new Object());
            if (null == lock) {
                lock = CLUSTER_LOCK.get(clusterName);
            }
            Object object = lock;
            synchronized (object) {
                if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
                    boolean exist = this.checkExists(ROOT_PATH + clusterName);
                    if (!exist) {
                        return null;
                    }
                    List childClusterPath = (List)this.getClientInstance().getChildren().forPath(ROOT_PATH + clusterName);
                    this.refreshClusterAddressMap(clusterName, childClusterPath);
                    this.subscribeCluster(clusterName);
                }
            }
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    public void close() throws Exception {
        this.getClientInstance().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CuratorFramework getClientInstance() {
        if (zkClient != null) return zkClient;
        Class<ZookeeperRegisterServiceImpl> clazz = ZookeeperRegisterServiceImpl.class;
        synchronized (ZookeeperRegisterServiceImpl.class) {
            if (zkClient != null) return zkClient;
            zkClient = this.buildZkClient(FILE_CONFIG.getConfig("registry.zk.serverAddr"), FILE_CONFIG.getInt("registry.zk.sessionTimeout", 6000), FILE_CONFIG.getInt("registry.zk.connectTimeout", 2000), FILE_CONFIG.getConfig("registry.zk.username"), FILE_CONFIG.getConfig("registry.zk.password"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zkClient;
        }
    }

    CuratorFramework buildZkClient(String address, int sessionTimeout, int connectTimeout, String ... authInfo) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(address).retryPolicy((RetryPolicy)new RetryNTimes(1, 1000)).connectionTimeoutMs(connectTimeout).sessionTimeoutMs(sessionTimeout);
        if (authInfo != null && authInfo.length == 2 && !StringUtils.isBlank((String)authInfo[0]) && !StringUtils.isBlank((String)authInfo[1])) {
            StringBuilder auth = new StringBuilder(authInfo[0]).append(":").append(authInfo[1]);
            builder.authorization("digest", auth.toString().getBytes());
        }
        zkClient = builder.build();
        zkClient.start();
        if (!this.checkExists(ROOT_PATH_WITHOUT_SUFFIX)) {
            this.createPersistent(ROOT_PATH_WITHOUT_SUFFIX, Boolean.TRUE.toString());
        }
        this.subscribeStateChanges();
        return zkClient;
    }

    private void subscribeStateChanges() {
        this.getClientInstance().getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (newState == ConnectionState.RECONNECTED || newState == ConnectionState.CONNECTED) {
                    try {
                        ZookeeperRegisterServiceImpl.this.recover();
                    }
                    catch (Exception e) {
                        LOGGER.error("handleNewSession error", (Throwable)e);
                    }
                } else {
                    LOGGER.error("stateChanged error, newState:{}", (Object)newState);
                }
            }
        });
    }

    private void recover() throws Exception {
        if (!REGISTERED_PATH_SET.isEmpty()) {
            REGISTERED_PATH_SET.forEach(this::doRegister);
        }
        if (!LISTENER_SERVICE_MAP.isEmpty()) {
            HashMap<String, List<CuratorCacheListener>> listenerMap = new HashMap<String, List<CuratorCacheListener>>(LISTENER_SERVICE_MAP);
            LISTENER_SERVICE_MAP.clear();
            for (Map.Entry listenerEntry : listenerMap.entrySet()) {
                List iZkChildListeners = (List)listenerEntry.getValue();
                if (CollectionUtils.isEmpty((Collection)iZkChildListeners)) continue;
                for (CuratorCacheListener listener : iZkChildListeners) {
                    this.subscribe((String)listenerEntry.getKey(), listener);
                }
            }
        }
    }

    private void subscribeCluster(final String cluster) throws Exception {
        final String path = ROOT_PATH + cluster;
        CuratorCacheListenerBuilder builder = CuratorCacheListener.builder();
        CuratorCacheListener listener = builder.forPathChildrenCache(path, this.getClientInstance(), new PathChildrenCacheListener(){
            final /* synthetic */ ZookeeperRegisterServiceImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                List currentChilds = (List)this.this$0.getClientInstance().getChildren().forPath(path);
                if (CollectionUtils.isEmpty((Collection)currentChilds) && CLUSTER_ADDRESS_MAP.get(cluster) != null) {
                    CLUSTER_ADDRESS_MAP.remove(cluster);
                } else if (!CollectionUtils.isEmpty((Collection)currentChilds)) {
                    this.this$0.refreshClusterAddressMap(cluster, currentChilds);
                }
            }
        }).build();
        this.subscribe(cluster, listener);
    }

    private void refreshClusterAddressMap(String clusterName, List<String> instances) {
        ArrayList<InetSocketAddress> newAddressList = new ArrayList<InetSocketAddress>();
        if (instances == null) {
            CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
            return;
        }
        for (String path : instances) {
            try {
                String[] ipAndPort = NetUtil.splitIPPortStr((String)path);
                newAddressList.add(new InetSocketAddress(ipAndPort[0], Integer.parseInt(ipAndPort[1])));
            }
            catch (Exception e) {
                LOGGER.warn("The cluster instance info is error, instance info:{}", (Object)path);
            }
        }
        CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
        this.removeOfflineAddressesIfNecessary(this.transactionServiceGroup, clusterName, newAddressList);
    }

    private String getClusterName() {
        String clusterConfigName = String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, REGISTRY_CLUSTER);
        return FILE_CONFIG.getConfig(clusterConfigName);
    }

    private String getRegisterPathByPath(InetSocketAddress address) {
        return ROOT_PATH + this.getClusterName() + ZK_PATH_SPLIT_CHAR + NetUtil.toStringAddress((InetSocketAddress)address);
    }

    protected void createPersistent(String path, String data) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            zkClient.create().creatingParentsIfNeeded().forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                zkClient.setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected void createPersistent(String path) {
        try {
            zkClient.create().creatingParentsIfNeeded().forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected void createEphemeral(String path, String data) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            ((ACLBackgroundPathAndBytesable)this.getClientInstance().create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.getClientInstance().setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected boolean deletePath(String path) {
        try {
            this.getClientInstance().delete().deletingChildrenIfNeeded().forPath(path);
            return true;
        }
        catch (KeeperException.NoNodeException ignored) {
            return true;
        }
        catch (Exception e) {
            LOGGER.error("deletePath {} is error or timeout", (Object)path, (Object)e);
            return false;
        }
    }

    @VisibleForTesting
    CuratorFramework getZkClient() {
        return zkClient;
    }

    static {
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<CuratorCacheListener>>();
        CLUSTER_LOCK = new ConcurrentHashMap<String, Object>();
        nodeCacheMap = new ConcurrentHashMap<String, CuratorCache>();
        REGISTERED_PATH_SET = Collections.synchronizedSet(new HashSet(1));
    }
}

