/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.schemaregion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class SchemaRegionListeningFilter {
    private static final Map<PartialPath, List<PlanNodeType>> OPTION_PLAN_MAP = new HashMap<PartialPath, List<PlanNodeType>>();

    static boolean shouldPlanBeListened(PlanNode node) {
        try {
            return node.getType().getNodeType() == PlanNodeType.PIPE_ENRICHED_WRITE.getNodeType() || node.getType().getNodeType() == PlanNodeType.PIPE_ENRICHED_NON_WRITE.getNodeType() || OPTION_PLAN_MAP.values().stream().anyMatch(types -> types.contains((Object)node.getType()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Set<PlanNodeType> parseListeningPlanTypeSet(PipeParameters parameters) throws IllegalPathException {
        HashSet<PlanNodeType> planTypes = new HashSet<PlanNodeType>();
        Set inclusionOptions = PipeInclusionOptions.parseOptions((String)parameters.getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data.insert"));
        Set exclusionOptions = PipeInclusionOptions.parseOptions((String)parameters.getStringOrDefault(Arrays.asList("extractor.inclusion.exclusion", "source.inclusion.exclusion"), ""));
        inclusionOptions.forEach(inclusion -> planTypes.addAll(OPTION_PLAN_MAP.keySet().stream().filter(path -> path.overlapWithFullPathPrefix(inclusion)).map(OPTION_PLAN_MAP::get).flatMap(Collection::stream).collect(Collectors.toSet())));
        exclusionOptions.forEach(exclusion -> planTypes.removeAll(OPTION_PLAN_MAP.keySet().stream().filter(path -> path.overlapWithFullPathPrefix(exclusion)).map(OPTION_PLAN_MAP::get).flatMap(Collection::stream).collect(Collectors.toSet())));
        return planTypes;
    }

    private SchemaRegionListeningFilter() {
    }

    static {
        try {
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.view.create"), Collections.singletonList(PlanNodeType.CREATE_LOGICAL_VIEW));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.view.alter"), Collections.singletonList(PlanNodeType.ALTER_LOGICAL_VIEW));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.ordinary.create"), Collections.unmodifiableList(Arrays.asList(PlanNodeType.CREATE_TIME_SERIES, PlanNodeType.CREATE_ALIGNED_TIME_SERIES, PlanNodeType.CREATE_MULTI_TIME_SERIES, PlanNodeType.INTERNAL_CREATE_MULTI_TIMESERIES, PlanNodeType.INTERNAL_CREATE_TIME_SERIES)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.ordinary.alter"), Collections.singletonList(PlanNodeType.ALTER_TIME_SERIES));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.activate"), Collections.unmodifiableList(Arrays.asList(PlanNodeType.ACTIVATE_TEMPLATE, PlanNodeType.BATCH_ACTIVATE_TEMPLATE, PlanNodeType.INTERNAL_BATCH_ACTIVATE_TEMPLATE)));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }
}

