/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression;

import java.nio.charset.StandardCharsets;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.BinaryOperator;
import org.apache.tsfile.utils.Binary;

public enum ComparisonOperator implements BinaryOperator
{
    LESS_THAN{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return false;
            }
            return ComparisonOperator.compare(left, right) < 0;
        }
    }
    ,
    GREATER_THAN{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return false;
            }
            return ComparisonOperator.compare(left, right) > 0;
        }
    }
    ,
    EQUAL{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            return ComparisonOperator.compare(left, right) == 0;
        }
    }
    ,
    NOT_EQUAL{

        @Override
        public Object apply(Object left, Object right) {
            Boolean eq = (Boolean)EQUAL.apply(left, right);
            return eq == false;
        }
    }
    ,
    LESS_THAN_OR_EQUAL{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return false;
            }
            return ComparisonOperator.compare(left, right) <= 0;
        }
    }
    ,
    GREATER_THAN_OR_EQUAL{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return false;
            }
            return ComparisonOperator.compare(left, right) >= 0;
        }
    }
    ,
    IS_DISTINCT_FROM{

        @Override
        public Object apply(Object left, Object right) {
            return NOT_EQUAL.apply(left, right);
        }
    };

    private static final double EPSILON = 1.0E-7;

    private static int compare(Object left, Object right) {
        if (left == null || right == null) {
            return -1;
        }
        NormalizedValue normLeft = ComparisonOperator.normalize(left);
        NormalizedValue normRight = ComparisonOperator.normalize(right);
        if (normLeft.type == NormalizedValue.Type.DOUBLE && normRight.type == NormalizedValue.Type.DOUBLE) {
            double d2;
            double d1 = (Double)normLeft.value;
            if (ComparisonOperator.almostEqual(d1, d2 = ((Double)normRight.value).doubleValue())) {
                return 0;
            }
            return Double.compare(d1, d2);
        }
        if (normLeft.type != normRight.type) {
            throw new SemanticException("Cannot compare values of different types: " + (Object)((Object)normLeft.type) + " vs. " + (Object)((Object)normRight.type));
        }
        return normLeft.compareTo(normRight);
    }

    private static boolean almostEqual(double a, double b) {
        double diff = Math.abs(a - b);
        return diff <= 1.0E-7;
    }

    private static NormalizedValue normalize(Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            Binary binary = new Binary(s, StandardCharsets.UTF_8);
            return new NormalizedValue(NormalizedValue.Type.BINARY, binary);
        }
        if (obj instanceof Number) {
            return new NormalizedValue(NormalizedValue.Type.DOUBLE, ((Number)obj).doubleValue());
        }
        if (obj instanceof Boolean) {
            return new NormalizedValue(NormalizedValue.Type.BOOLEAN, obj);
        }
        if (obj instanceof Binary) {
            return new NormalizedValue(NormalizedValue.Type.BINARY, obj);
        }
        if (obj instanceof byte[]) {
            return new NormalizedValue(NormalizedValue.Type.BINARY, new Binary((byte[])obj));
        }
        throw new SemanticException("Unsupported type: " + obj.getClass());
    }

    private static class NormalizedValue
    implements Comparable<NormalizedValue> {
        final Type type;
        final Object value;

        NormalizedValue(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public int compareTo(NormalizedValue other) {
            switch (this.type) {
                case DOUBLE: {
                    return Double.compare((Double)this.value, (Double)other.value);
                }
                case STRING: {
                    return ((String)this.value).compareTo((String)other.value);
                }
                case BOOLEAN: {
                    return Boolean.compare((Boolean)this.value, (Boolean)other.value);
                }
                case BINARY: {
                    return ((Binary)this.value).compareTo((Binary)other.value);
                }
            }
            throw new SemanticException("Unknown type: " + (Object)((Object)this.type));
        }

        static enum Type {
            DOUBLE,
            STRING,
            BOOLEAN,
            BINARY;

        }
    }
}

