/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.memory;

import java.util.Arrays;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.memory.GlobalMemoryMetrics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaEngineMemoryMetrics
implements IMetricSet {
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final String SCHEMA_ENGINE = "SchemaEngine";
    private static final String SCHEMA_ENGINE_SCHEMA_REGION = "SchemaEngine-SchemaRegion";
    private static final String SCHEMA_ENGINE_SCHEMA_CACHE = "SchemaEngine-SchemaCache";
    private static final String SCHEMA_ENGINE_PARTITION_CACHE = "SchemaEngine-PartitionCache";

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getSchemaEngineMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getSchemaRegionMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE_SCHEMA_REGION, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getSchemaRegionMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE_SCHEMA_REGION, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getSchemaCacheMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE_SCHEMA_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getSchemaCacheMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE_SCHEMA_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getPartitionCacheMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE_PARTITION_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getPartitionCacheMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), SCHEMA_ENGINE_PARTITION_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), SCHEMA_ENGINE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        Arrays.asList(SCHEMA_ENGINE_SCHEMA_REGION, SCHEMA_ENGINE_SCHEMA_CACHE, SCHEMA_ENGINE_PARTITION_CACHE).forEach(name -> {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_ACTUAL_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        });
    }

    public static SchemaEngineMemoryMetrics getInstance() {
        return SchemaEngineMemoryMetricsHolder.INSTANCE;
    }

    private static class SchemaEngineMemoryMetricsHolder {
        private static final SchemaEngineMemoryMetrics INSTANCE = new SchemaEngineMemoryMetrics();

        private SchemaEngineMemoryMetricsHolder() {
        }
    }
}

