/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.subscriptions.CTrie;
import io.moquette.broker.subscriptions.ISubscriptionsDirectory;
import io.moquette.broker.subscriptions.ShareName;
import io.moquette.broker.subscriptions.SharedSubscription;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionIdentifier;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTrieSubscriptionDirectory
implements ISubscriptionsDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(CTrieSubscriptionDirectory.class);
    private CTrie ctrie;
    private volatile ISubscriptionsRepository subscriptionsRepository;
    private final ConcurrentMap<String, List<SharedSubscription>> clientSharedSubscriptions = new ConcurrentHashMap<String, List<SharedSubscription>>();

    @Override
    public void init(ISubscriptionsRepository subscriptionsRepository) {
        LOG.info("Initializing CTrie");
        this.ctrie = new CTrie();
        LOG.info("Initializing subscriptions store...");
        this.subscriptionsRepository = subscriptionsRepository;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reloading all stored subscriptions. SubscriptionTree = {}", (Object)this.dumpTree());
        }
        for (Subscription subscription : this.subscriptionsRepository.listAllSubscriptions()) {
            LOG.debug("Re-subscribing {}", (Object)subscription);
            this.ctrie.addToTree(CTrie.SubscriptionRequest.buildNonShared(subscription));
        }
        for (SharedSubscription shared : subscriptionsRepository.listAllSharedSubscription()) {
            LOG.debug("Re-subscribing shared {}", (Object)shared);
            this.ctrie.addToTree(CTrie.SubscriptionRequest.buildShared(shared.getShareName(), shared.topicFilter(), shared.clientId(), MqttSubscriptionOption.onlyFromQos((MqttQoS)shared.requestedQoS())));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stored subscriptions have been reloaded. SubscriptionTree = {}", (Object)this.dumpTree());
        }
    }

    @Override
    public List<Subscription> matchWithoutQosSharpening(Topic topicName) {
        return this.ctrie.recursiveMatch(topicName);
    }

    @Override
    public List<Subscription> matchQosSharpening(Topic topicName) {
        List<Subscription> subscriptions = this.matchWithoutQosSharpening(topicName);
        return CTrieSubscriptionDirectory.selectSubscriptionsWithHigherQoSForEachSession(subscriptions);
    }

    private static List<Subscription> selectSubscriptionsWithHigherQoSForEachSession(List<Subscription> subscriptions) {
        HashMap<String, Subscription> subsGroupedByClient = new HashMap<String, Subscription>();
        for (Subscription sub : subscriptions) {
            String key = sub.clientAndShareName();
            Subscription existingSub = (Subscription)subsGroupedByClient.get(key);
            if (existingSub != null && !existingSub.qosLessThan(sub)) continue;
            subsGroupedByClient.put(key, sub);
        }
        return new ArrayList<Subscription>(subsGroupedByClient.values());
    }

    @Override
    public boolean add(String clientId, Topic filter, MqttSubscriptionOption option) {
        CTrie.SubscriptionRequest subRequest = CTrie.SubscriptionRequest.buildNonShared(clientId, filter, option);
        return this.addNonSharedSubscriptionRequest(subRequest);
    }

    @Override
    public boolean add(String clientId, Topic filter, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionId) {
        CTrie.SubscriptionRequest subRequest = CTrie.SubscriptionRequest.buildNonShared(clientId, filter, option, subscriptionId);
        return this.addNonSharedSubscriptionRequest(subRequest);
    }

    private boolean addNonSharedSubscriptionRequest(CTrie.SubscriptionRequest subRequest) {
        boolean notExistingSubscription = this.ctrie.addToTree(subRequest);
        this.subscriptionsRepository.addNewSubscription(subRequest.subscription());
        return notExistingSubscription;
    }

    @Override
    public void addShared(String clientId, ShareName name, Topic topicFilter, MqttSubscriptionOption option) {
        CTrie.SubscriptionRequest shareSubRequest = CTrie.SubscriptionRequest.buildShared(name, topicFilter, clientId, option);
        this.addSharedSubscriptionRequest(shareSubRequest);
    }

    private void addSharedSubscriptionRequest(CTrie.SubscriptionRequest shareSubRequest) {
        this.ctrie.addToTree(shareSubRequest);
        if (shareSubRequest.hasSubscriptionIdentifier()) {
            this.subscriptionsRepository.addNewSharedSubscription(shareSubRequest.getClientId(), shareSubRequest.getSharedName(), shareSubRequest.getTopicFilter(), shareSubRequest.getOption(), shareSubRequest.getSubscriptionIdentifier());
        } else {
            this.subscriptionsRepository.addNewSharedSubscription(shareSubRequest.getClientId(), shareSubRequest.getSharedName(), shareSubRequest.getTopicFilter(), shareSubRequest.getOption());
        }
        List sharedSubscriptions = this.clientSharedSubscriptions.computeIfAbsent(shareSubRequest.getClientId(), unused -> new ArrayList());
        sharedSubscriptions.add(shareSubRequest.sharedSubscription());
    }

    @Override
    public void addShared(String clientId, ShareName name, Topic topicFilter, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionId) {
        CTrie.SubscriptionRequest shareSubRequest = CTrie.SubscriptionRequest.buildShared(name, topicFilter, clientId, option, subscriptionId);
        this.addSharedSubscriptionRequest(shareSubRequest);
    }

    @Override
    public void removeSubscription(Topic topic, String clientID) {
        CTrie.UnsubscribeRequest request = CTrie.UnsubscribeRequest.buildNonShared(clientID, topic);
        this.ctrie.removeFromTree(request);
        this.subscriptionsRepository.removeSubscription(topic.toString(), clientID);
    }

    @Override
    public void removeSharedSubscription(ShareName name, Topic topicFilter, String clientId) {
        CTrie.UnsubscribeRequest request = CTrie.UnsubscribeRequest.buildShared(name, topicFilter, clientId);
        this.ctrie.removeFromTree(request);
        this.subscriptionsRepository.removeSharedSubscription(clientId, name, topicFilter);
        SharedSubscription sharedSubscription = new SharedSubscription(name, topicFilter, clientId, MqttSubscriptionOption.onlyFromQos((MqttQoS)MqttQoS.AT_MOST_ONCE));
        List sharedSubscriptions = (List)this.clientSharedSubscriptions.get(clientId);
        if (sharedSubscriptions != null && !sharedSubscriptions.isEmpty()) {
            sharedSubscriptions.remove(sharedSubscription);
            this.clientSharedSubscriptions.replace(clientId, sharedSubscriptions);
        }
    }

    @Override
    public int size() {
        return this.ctrie.size();
    }

    @Override
    public String dumpTree() {
        return this.ctrie.dumpTree();
    }

    @Override
    public void removeSharedSubscriptionsForClient(String clientId) {
        List sessionSharedSubscriptions = (List)this.clientSharedSubscriptions.remove(clientId);
        if (sessionSharedSubscriptions != null) {
            for (SharedSubscription subscription : sessionSharedSubscriptions) {
                CTrie.UnsubscribeRequest request = CTrie.UnsubscribeRequest.buildShared(subscription.getShareName(), subscription.topicFilter(), clientId);
                this.ctrie.removeFromTree(request);
            }
        }
        this.subscriptionsRepository.removeAllSharedSubscriptions(clientId);
    }
}

