/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractMergeSortJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class MergeSortFullOuterJoinOperator
extends AbstractMergeSortJoinOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MergeSortFullOuterJoinOperator.class);
    private TsBlock lastMatchedRightBlock = null;
    private final int[] lastMatchedBlockPositions;
    private final List<BiFunction<Column, Integer, Column>> updateLastMatchedRowFunctions;

    public MergeSortFullOuterJoinOperator(OperatorContext operatorContext, Operator leftChild, int[] leftJoinKeyPositions, int[] leftOutputSymbolIdx, Operator rightChild, int[] rightJoinKeyPositions, int[] rightOutputSymbolIdx, List<JoinKeyComparator> joinKeyComparators, List<TSDataType> dataTypes, List<BiFunction<Column, Integer, Column>> updateLastMatchedRowFunctions) {
        super(operatorContext, leftChild, leftJoinKeyPositions, leftOutputSymbolIdx, rightChild, rightJoinKeyPositions, rightOutputSymbolIdx, joinKeyComparators, dataTypes);
        this.lastMatchedBlockPositions = new int[joinKeyComparators.size()];
        for (int i = 0; i < this.lastMatchedBlockPositions.length; ++i) {
            this.lastMatchedBlockPositions[i] = i;
        }
        this.updateLastMatchedRowFunctions = updateLastMatchedRowFunctions;
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        return !this.leftFinished || !this.rightFinished;
    }

    @Override
    protected boolean prepareInput() throws Exception {
        this.gotCandidateBlocks();
        if (this.leftFinished) {
            return this.rightBlockNotEmpty() && this.gotNextRightBlock();
        }
        if (this.rightFinished) {
            return this.leftBlockNotEmpty();
        }
        return this.leftBlockNotEmpty() && this.rightBlockNotEmpty() && this.gotNextRightBlock();
    }

    @Override
    protected boolean processFinished() {
        if (this.leftFinished || this.rightFinished) {
            this.buildUseRemainingBlocks();
            return true;
        }
        if (this.allRightLessThanLeft()) {
            this.appendRightWithEmptyLeft();
            this.resetRightBlockList();
            return true;
        }
        if (this.allLeftLessThanRight()) {
            this.appendLeftWithEmptyRight();
            this.resetLeftBlock();
            return true;
        }
        while (this.currentRightHasNullValue()) {
            this.appendOneRightRowWithEmptyLeft();
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        while (this.lessThan((TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex, this.leftBlock, this.leftJoinKeyPositions, this.leftIndex)) {
            if (this.lastMatchedRightBlock == null) {
                this.appendOneRightRowWithEmptyLeft();
            } else if (!this.equalsTo(this.lastMatchedRightBlock, this.lastMatchedBlockPositions, 0, (TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex)) {
                this.appendOneRightRowWithEmptyLeft();
            }
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        if (this.currentRoundNeedStop()) {
            return true;
        }
        while (this.currentLeftHasNullValue()) {
            this.appendOneLeftRowWithEmptyRight();
            if (!this.leftFinishedWithIncIndex()) continue;
            return true;
        }
        while (this.lessThan(this.leftBlock, this.leftJoinKeyPositions, this.leftIndex, (TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex)) {
            this.appendOneLeftRowWithEmptyRight();
            if (!this.leftFinishedWithIncIndex()) continue;
            return true;
        }
        if (this.currentRoundNeedStop()) {
            return true;
        }
        return this.hasMatchedRightValueToProbeLeft() && this.leftFinishedWithIncIndex();
    }

    @Override
    protected void recordsWhenDataMatches() {
        Column[] valueColumns = new Column[this.leftJoinKeyPositions.length];
        for (int i = 0; i < this.leftJoinKeyPositions.length; ++i) {
            valueColumns[i] = this.updateLastMatchedRowFunctions.get(i).apply(this.leftBlock.getColumn(this.leftJoinKeyPositions[i]), this.leftIndex);
        }
        this.lastMatchedRightBlock = new TsBlock(1, (Column)TableScanOperator.TIME_COLUMN_TEMPLATE, valueColumns);
    }

    private void buildUseRemainingBlocks() {
        if (this.leftFinished) {
            this.appendRightWithEmptyLeft();
            this.resetRightBlockList();
        } else {
            this.appendLeftWithEmptyRight();
            this.resetLeftBlock();
        }
    }

    private void appendRightWithEmptyLeft() {
        while (this.rightBlockListIdx < this.rightBlockList.size()) {
            if (this.lastMatchedRightBlock == null || !this.equalsTo(this.lastMatchedRightBlock, this.lastMatchedBlockPositions, 0, (TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex)) {
                for (int i = 0; i < this.leftOutputSymbolIdx.length; ++i) {
                    ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
                    columnBuilder.appendNull();
                }
                this.appendRightBlockData(this.rightBlockList, this.rightBlockListIdx, this.rightIndex, this.leftOutputSymbolIdx, this.rightOutputSymbolIdx, this.resultBuilder);
                this.resultBuilder.declarePosition();
            }
            ++this.rightIndex;
            if (this.rightIndex < ((TsBlock)this.rightBlockList.get(this.rightBlockListIdx)).getPositionCount()) continue;
            this.rightIndex = 0;
            ++this.rightBlockListIdx;
        }
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.leftChild) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.rightChild) + RamUsageEstimator.sizeOf((int[])this.leftOutputSymbolIdx) + RamUsageEstimator.sizeOf((int[])this.rightOutputSymbolIdx) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.resultBuilder.getRetainedSizeInBytes();
    }
}

