/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.time.Duration;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDateTimeUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CommonDateTimeUtils.class);

    public static long convertMilliTimeWithPrecision(long milliTime, String timePrecision) {
        long result = milliTime;
        switch (timePrecision) {
            case "ns": {
                result = milliTime * 1000000L;
                break;
            }
            case "us": {
                result = milliTime * 1000L;
                break;
            }
        }
        if (result < 0L) {
            LOGGER.warn("Integer overflow when converting {}ms to {}{}.", new Object[]{milliTime, result, timePrecision});
            result = Long.MAX_VALUE;
        }
        return result;
    }

    public static long convertIoTDBTimeToMillis(long time) {
        String timePrecision;
        switch (timePrecision = CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                return time / 1000000L;
            }
            case "us": {
                return time / 1000L;
            }
        }
        return time;
    }

    public static long currentTime() {
        String timePrecision;
        long startupNano = CommonDescriptor.getInstance().getConfig().getStartUpNanosecond();
        switch (timePrecision = CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                return System.currentTimeMillis() * 1000000L + (System.nanoTime() - startupNano) % 1000000L;
            }
            case "us": {
                return System.currentTimeMillis() * 1000L + (System.nanoTime() - startupNano) / 1000L % 1000L;
            }
        }
        return System.currentTimeMillis();
    }

    public static String convertMillisecondToDurationStr(long millisecond) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean minus = false;
        if (millisecond < 0L) {
            minus = true;
            millisecond = -millisecond;
            stringBuilder.append("-(");
        }
        Duration duration = Duration.ofMillis(millisecond);
        long days = duration.toDays();
        long years = days / 365L;
        long months = (days %= 365L) / 30L;
        days %= 30L;
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        long ms = millisecond % 1000L;
        BiConsumer<Long, String> append = (value, unit) -> {
            if (value > 0L) {
                stringBuilder.append(value).append(" ").append((String)unit).append(" ");
            }
        };
        append.accept(years, "year");
        append.accept(months, "month");
        append.accept(days, "day");
        append.accept(hours, "hour");
        append.accept(minutes, "minute");
        append.accept(seconds, "second");
        append.accept(ms, "ms");
        String result = stringBuilder.toString();
        if (result.endsWith(" ")) {
            result = result.substring(0, result.length() - 1);
        }
        if (minus) {
            result = result + ")";
        }
        if (result.isEmpty()) {
            result = "0 ms";
        }
        return result;
    }
}

