/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import jakarta.mail.Flags;
import java.util.Set;
import org.apache.james.mailbox.cassandra.table.Flag;

public class FlagsExtractor {
    public static final TypeCodec<Set<String>> SET_OF_STRINGS_CODEC = CodecRegistry.DEFAULT.codecFor((DataType)DataTypes.setOf((DataType)DataTypes.TEXT));

    public static Flags getFlags(Row row) {
        return FlagsExtractor.getFlags(row, row.protocolVersion());
    }

    private static Flags getFlags(Row row, ProtocolVersion protocolVersion) {
        Flags flags = new Flags();
        for (CqlIdentifier cqlId : Flag.ALL_LOWERCASE) {
            if (!TypeCodecs.BOOLEAN.decodePrimitive(row.getBytesUnsafe(cqlId), protocolVersion)) continue;
            flags.add((Flags.Flag)Flag.JAVAX_MAIL_FLAG.get((Object)cqlId));
        }
        ((Set)row.get(Flag.USER_FLAGS, SET_OF_STRINGS_CODEC)).forEach(arg_0 -> ((Flags)flags).add(arg_0));
        return flags;
    }

    public static Flags getApplicableFlags(Row row) {
        Flags flags = new Flags();
        ((Set)row.get(Flag.USER_FLAGS, SET_OF_STRINGS_CODEC)).forEach(arg_0 -> ((Flags)flags).add(arg_0));
        return flags;
    }
}

