/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RouteToServerRequestControl
extends Control {
    @NotNull
    public static final String ROUTE_TO_SERVER_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.16";
    private static final byte TYPE_SERVER_ID = -128;
    private static final byte TYPE_ALLOW_ALTERNATE_SERVER = -127;
    private static final byte TYPE_PREFER_LOCAL_SERVER = -126;
    private static final byte TYPE_PREFER_NON_DEGRADED_SERVER = -125;
    @NotNull
    private static final String JSON_FIELD_ALLOW_ALTERNATE_SERVER = "allow-alternate-server";
    @NotNull
    private static final String JSON_FIELD_PREFER_LOCAL_SERVER = "prefer-local-server";
    @NotNull
    private static final String JSON_FIELD_PREFER_NON_DEGRADED_SERVER = "prefer-non-degraded-server";
    @NotNull
    private static final String JSON_FIELD_SERVER_ID = "server-id";
    private static final long serialVersionUID = 2100638364623466061L;
    private final boolean allowAlternateServer;
    private final boolean preferLocalServer;
    private final boolean preferNonDegradedServer;
    @NotNull
    private final String serverID;

    public RouteToServerRequestControl(boolean isCritical, @NotNull String serverID, boolean allowAlternateServer, boolean preferLocalServer, boolean preferNonDegradedServer) {
        super(ROUTE_TO_SERVER_REQUEST_OID, isCritical, RouteToServerRequestControl.encodeValue(serverID, allowAlternateServer, preferLocalServer, preferNonDegradedServer));
        this.serverID = serverID;
        this.allowAlternateServer = allowAlternateServer;
        this.preferLocalServer = allowAlternateServer && preferLocalServer;
        this.preferNonDegradedServer = allowAlternateServer && preferNonDegradedServer;
    }

    public RouteToServerRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Sequence valueSequence;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_SERVER_REQUEST_MISSING_VALUE.get());
        }
        try {
            valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_SERVER_REQUEST_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Element[] elements = valueSequence.elements();
            this.serverID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            boolean preferLocal = this.allowAlternateServer = ASN1Boolean.decodeAsBoolean(elements[1]).booleanValue();
            boolean preferNonDegraded = this.allowAlternateServer;
            block9: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -126: {
                        preferLocal = this.allowAlternateServer && ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block9;
                    }
                    case -125: {
                        preferNonDegraded = this.allowAlternateServer && ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_SERVER_REQUEST_INVALID_VALUE_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.preferLocalServer = preferLocal;
            this.preferNonDegradedServer = preferNonDegraded;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_SERVER_REQUEST_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String serverID, boolean allowAlternateServer, boolean preferLocalServer, boolean preferNonDegradedServer) {
        Validator.ensureNotNull(serverID);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1OctetString(-128, serverID));
        elements.add(new ASN1Boolean(-127, allowAlternateServer));
        if (allowAlternateServer && !preferLocalServer) {
            elements.add(new ASN1Boolean(-126, false));
        }
        if (allowAlternateServer && !preferNonDegradedServer) {
            elements.add(new ASN1Boolean(-125, false));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String getServerID() {
        return this.serverID;
    }

    public boolean allowAlternateServer() {
        return this.allowAlternateServer;
    }

    public boolean preferLocalServer() {
        return this.preferLocalServer;
    }

    public boolean preferNonDegradedServer() {
        return this.preferNonDegradedServer;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ROUTE_TO_SERVER_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_SERVER_ID, new JSONString(this.serverID));
        valueFields.put(JSON_FIELD_ALLOW_ALTERNATE_SERVER, new JSONBoolean(this.allowAlternateServer));
        if (this.allowAlternateServer) {
            valueFields.put(JSON_FIELD_PREFER_LOCAL_SERVER, new JSONBoolean(this.preferLocalServer));
            valueFields.put(JSON_FIELD_PREFER_NON_DEGRADED_SERVER, new JSONBoolean(this.preferNonDegradedServer));
        }
        return new JSONObject(new JSONField("oid", ROUTE_TO_SERVER_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_ROUTE_TO_SERVER_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static RouteToServerRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        Boolean preferNonDegradedServer;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new RouteToServerRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String serverID = valueObject.getFieldAsString(JSON_FIELD_SERVER_ID);
        if (serverID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_SERVER_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_SERVER_ID));
        }
        Boolean allowAlternateServer = valueObject.getFieldAsBoolean(JSON_FIELD_ALLOW_ALTERNATE_SERVER);
        if (allowAlternateServer == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_SERVER_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_ALLOW_ALTERNATE_SERVER));
        }
        Boolean preferLocalServer = valueObject.getFieldAsBoolean(JSON_FIELD_PREFER_LOCAL_SERVER);
        if (preferLocalServer == null) {
            preferLocalServer = true;
        }
        if ((preferNonDegradedServer = valueObject.getFieldAsBoolean(JSON_FIELD_PREFER_NON_DEGRADED_SERVER)) == null) {
            preferNonDegradedServer = true;
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SERVER_ID, JSON_FIELD_ALLOW_ALTERNATE_SERVER, JSON_FIELD_PREFER_LOCAL_SERVER, JSON_FIELD_PREFER_NON_DEGRADED_SERVER)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_SERVER_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new RouteToServerRequestControl(jsonControl.getCriticality(), serverID, allowAlternateServer, preferLocalServer, preferNonDegradedServer);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("RouteToServerRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", serverID='");
        buffer.append(this.serverID);
        buffer.append("', allowAlternateServer=");
        buffer.append(this.allowAlternateServer);
        buffer.append(", preferLocalServer=");
        buffer.append(this.preferLocalServer);
        buffer.append(", preferNonDegradedServer=");
        buffer.append(this.preferNonDegradedServer);
        buffer.append(')');
    }
}

