/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres.quota;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.function.Function;
import org.apache.james.backends.postgres.quota.PostgresQuotaDataDefinition;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCurrentValue;
import org.apache.james.core.quota.QuotaType;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresQuotaCurrentValueDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresQuotaCurrentValueDAO.class);
    private static final boolean IS_INCREASE = true;
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresQuotaCurrentValueDAO(@Named(value="default") PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Void> increase(QuotaCurrentValue.Key quotaKey, long amount) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TABLE_NAME).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.IDENTIFIER, (Object)quotaKey.getIdentifier()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.COMPONENT, (Object)quotaKey.getQuotaComponent().getValue()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE, (Object)quotaKey.getQuotaType().getValue()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE, (Object)amount).onConflictOnConstraint(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.PRIMARY_KEY_CONSTRAINT_NAME).doUpdate().set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE, PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE.plus((Number)amount)))).onErrorResume(ex -> {
            LOGGER.warn("Failure when increasing {} {} quota for {}. Quota current value is thus not updated and needs re-computation", new Object[]{quotaKey.getQuotaComponent().getValue(), quotaKey.getQuotaType().getValue(), quotaKey.getIdentifier(), ex});
            return Mono.empty();
        });
    }

    public Mono<Long> upsert(QuotaCurrentValue.Key quotaKey, long newCurrentValue) {
        return this.update(quotaKey, newCurrentValue).switchIfEmpty(Mono.defer(() -> this.insert(quotaKey, newCurrentValue, true)));
    }

    public Mono<Long> update(QuotaCurrentValue.Key quotaKey, long newCurrentValue) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.update(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TABLE_NAME).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE, (Object)newCurrentValue).where(new Condition[]{PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.IDENTIFIER.eq((Object)quotaKey.getIdentifier()), PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.COMPONENT.eq((Object)quotaKey.getQuotaComponent().getValue()), PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE.eq((Object)quotaKey.getQuotaType().getValue())}).returning(new SelectFieldOrAsterisk[]{PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE}))).map(record -> (Long)record.get(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE));
    }

    public Mono<Long> insert(QuotaCurrentValue.Key quotaKey, long amount, boolean isIncrease) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TABLE_NAME).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.IDENTIFIER, (Object)quotaKey.getIdentifier()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.COMPONENT, (Object)quotaKey.getQuotaComponent().getValue()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE, (Object)quotaKey.getQuotaType().getValue()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE, (Object)this.newCurrentValue(amount, isIncrease)).returning(new SelectFieldOrAsterisk[]{PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE}))).map(record -> (Long)record.get(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE));
    }

    private Long newCurrentValue(long amount, boolean isIncrease) {
        if (isIncrease) {
            return amount;
        }
        return -amount;
    }

    public Mono<Void> decrease(QuotaCurrentValue.Key quotaKey, long amount) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TABLE_NAME).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.IDENTIFIER, (Object)quotaKey.getIdentifier()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.COMPONENT, (Object)quotaKey.getQuotaComponent().getValue()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE, (Object)quotaKey.getQuotaType().getValue()).set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE, (Object)(-amount)).onConflictOnConstraint(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.PRIMARY_KEY_CONSTRAINT_NAME).doUpdate().set(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE, PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE.minus((Number)amount)))).onErrorResume(ex -> {
            LOGGER.warn("Failure when decreasing {} {} quota for {}. Quota current value is thus not updated and needs re-computation", new Object[]{quotaKey.getQuotaComponent().getValue(), quotaKey.getQuotaType().getValue(), quotaKey.getIdentifier(), ex});
            return Mono.empty();
        });
    }

    public Mono<QuotaCurrentValue> getQuotaCurrentValue(QuotaCurrentValue.Key quotaKey) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE).from(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TABLE_NAME).where(new Condition[]{PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.IDENTIFIER.eq((Object)quotaKey.getIdentifier()), PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.COMPONENT.eq((Object)quotaKey.getQuotaComponent().getValue()), PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE.eq((Object)quotaKey.getQuotaType().getValue())}))).map(this.toQuotaCurrentValue(quotaKey));
    }

    public Mono<Void> deleteQuotaCurrentValue(QuotaCurrentValue.Key quotaKey) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TABLE_NAME).where(new Condition[]{PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.IDENTIFIER.eq((Object)quotaKey.getIdentifier()), PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.COMPONENT.eq((Object)quotaKey.getQuotaComponent().getValue()), PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE.eq((Object)quotaKey.getQuotaType().getValue())})));
    }

    public Flux<QuotaCurrentValue> getQuotaCurrentValues(QuotaComponent quotaComponent, String identifier) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE, PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE).from(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TABLE_NAME).where(new Condition[]{PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.IDENTIFIER.eq((Object)identifier), PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.COMPONENT.eq((Object)quotaComponent.getValue())}))).map(PostgresQuotaCurrentValueDAO.toQuotaCurrentValue(quotaComponent, identifier));
    }

    private Function<Record, QuotaCurrentValue> toQuotaCurrentValue(QuotaCurrentValue.Key quotaKey) {
        return record -> QuotaCurrentValue.builder().quotaComponent(quotaKey.getQuotaComponent()).identifier(quotaKey.getIdentifier()).quotaType(quotaKey.getQuotaType()).currentValue(((Long)record.get(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE)).longValue()).build();
    }

    private static Function<Record, QuotaCurrentValue> toQuotaCurrentValue(QuotaComponent quotaComponent, String identifier) {
        return record -> QuotaCurrentValue.builder().quotaComponent(quotaComponent).identifier(identifier).quotaType(QuotaType.of((String)((String)record.get(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.TYPE)))).currentValue(((Long)record.get(PostgresQuotaDataDefinition.PostgresQuotaCurrentValueTable.CURRENT_VALUE)).longValue()).build();
    }
}

