/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.sys;

import java.util.UUID;
import org.apache.jena.atlas.lib.Bytes;

public class LibUUID {
    public static byte[] uuidAsBytes(UUID uuid) {
        return LibUUID.uuidAsBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static byte[] uuidAsBytes(long mostSignificantBits, long leastSignificantBits) {
        byte[] bytes = new byte[16];
        Bytes.setLong((long)mostSignificantBits, (byte[])bytes, (int)0);
        Bytes.setLong((long)leastSignificantBits, (byte[])bytes, (int)8);
        return bytes;
    }

    public static byte[] uuidAsBytes(String str) {
        return LibUUID.uuidAsBytes(UUID.fromString(str));
    }

    public static String uuidToString(long mostSignificantBits, long leastSignificantBits) {
        return new UUID(mostSignificantBits, leastSignificantBits).toString();
    }
}

