/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetAdapter;
import org.apache.jena.sparql.util.Context;

public class QueryExecAdapter
implements QueryExec {
    private QueryExecution queryExecution;

    protected QueryExecAdapter(QueryExecution queryExecution) {
        this.queryExecution = queryExecution;
    }

    protected QueryExecution get() {
        return this.queryExecution;
    }

    public static QueryExec adapt(QueryExecution qExec) {
        if (qExec instanceof QueryExecutionAdapter) {
            return ((QueryExecutionAdapter)qExec).get();
        }
        return new QueryExecAdapter(qExec);
    }

    @Override
    public DatasetGraph getDataset() {
        Dataset dataset = this.get().getDataset();
        return dataset == null ? null : dataset.asDatasetGraph();
    }

    @Override
    public Context getContext() {
        return this.get().getContext();
    }

    @Override
    public Query getQuery() {
        return this.get().getQuery();
    }

    @Override
    public String getQueryString() {
        Query q = this.getQuery();
        if (q == null) {
            return null;
        }
        return q.toString();
    }

    @Override
    public RowSet select() {
        return new RowSetAdapter(this.get().execSelect());
    }

    @Override
    public Graph construct() {
        return this.get().execConstruct().getGraph();
    }

    @Override
    public Graph construct(Graph graph) {
        this.get().execConstruct(ModelFactory.createModelForGraph((Graph)graph));
        return graph;
    }

    @Override
    public Iterator<Triple> constructTriples() {
        return this.get().execConstructTriples();
    }

    @Override
    public Iterator<Quad> constructQuads() {
        return this.get().execConstructQuads();
    }

    @Override
    public DatasetGraph constructDataset(DatasetGraph dataset) {
        this.get().execConstructDataset(DatasetFactory.wrap(dataset));
        return dataset;
    }

    @Override
    public Graph describe() {
        return this.get().execDescribe().getGraph();
    }

    @Override
    public Graph describe(Graph graph) {
        this.get().execConstruct(ModelFactory.createModelForGraph((Graph)graph));
        return graph;
    }

    @Override
    public Iterator<Triple> describeTriples() {
        return this.get().execDescribeTriples();
    }

    @Override
    public boolean ask() {
        return this.get().execAsk();
    }

    @Override
    public JsonArray execJson() {
        return this.get().execJson();
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        return this.get().execJsonItems();
    }

    @Override
    public void abort() {
        this.get().abort();
    }

    @Override
    public void close() {
        this.get().close();
    }

    @Override
    public boolean isClosed() {
        return this.get().isClosed();
    }
}

