/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi;

import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;

public interface UnionGraph
extends Graph {
    public EventManager getEventManager();

    public boolean isDistinct();

    public Graph getBaseGraph();

    public boolean hasSubGraph();

    public Stream<Graph> subGraphs();

    public Stream<UnionGraph> superGraphs();

    public UnionGraph addSubGraph(Graph var1);

    public UnionGraph removeSubGraph(Graph var1);

    default public UnionGraph addSubGraphIfAbsent(Graph graph) {
        if (!this.contains(graph)) {
            this.addSubGraph(graph);
        }
        return this;
    }

    default public boolean contains(Graph graph) {
        return this.subGraphs().anyMatch(it -> it.equals((Object)graph));
    }

    public static interface EventManager
    extends GraphEventManager,
    Listener {
        public void off();

        public void on();

        public Stream<GraphListener> listeners();

        default public <L extends GraphListener> Stream<L> listeners(Class<L> type) {
            return this.listeners().filter(it -> type.isAssignableFrom(it.getClass())).map(it -> it);
        }
    }

    public static interface Listener
    extends GraphListener {
        public void onAddTriple(UnionGraph var1, Triple var2);

        public void onDeleteTriple(UnionGraph var1, Triple var2);

        public void onClear(UnionGraph var1);

        public void onAddSubGraph(UnionGraph var1, Graph var2);

        public void onRemoveSubGraph(UnionGraph var1, Graph var2);

        public void notifySubGraphAdded(UnionGraph var1, Graph var2);

        public void notifySuperGraphAdded(UnionGraph var1, UnionGraph var2);

        public void notifySubGraphRemoved(UnionGraph var1, Graph var2);
    }
}

