/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.ResourceVocabulary;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface OntPersonality {
    public static Personality<RDFNode> asJenaPersonality(OntPersonality p) throws OntJenaException {
        if (p instanceof Personality) {
            return (Personality)p;
        }
        throw new OntJenaException.IllegalArgument("The given OntPersonality is not an instance of Jena Personality.");
    }

    public Stream<Class<? extends RDFNode>> types();

    public EnhNodeFactory getObjectFactory(Class<? extends RDFNode> var1);

    public boolean supports(Class<? extends RDFNode> var1);

    public OntPersonality copy();

    public String getName();

    public OntConfig getConfig();

    public Punnings getPunnings();

    public Builtins getBuiltins();

    public Reserved getReserved();

    public Set<String> forbidden(Class<? extends OntObject> var1);

    default public <T extends OntObject> Stream<Class<? extends T>> types(Class<T> type) {
        Objects.requireNonNull(type);
        return this.types().filter(c -> {
            if (c == type) return true;
            if (!Arrays.stream(c.getInterfaces()).anyMatch(type::isAssignableFrom)) return false;
            return true;
        }).map(x -> x);
    }

    public static interface Builtins
    extends ResourceVocabulary<OntObject> {
        default public Set<Class<? extends OntObject>> supportedTypes() {
            return Set.of(OntClass.Named.class, OntDataRange.Named.class, OntObjectProperty.Named.class, OntDataProperty.class, OntAnnotationProperty.class, OntProperty.class, OntEntity.class);
        }

        default public Set<Node> getNamedClasses() {
            return this.get(OntClass.Named.class);
        }

        default public Set<Node> getDatatypes() {
            return this.get(OntDataRange.Named.class);
        }

        default public Set<Node> getObjectProperties() {
            return this.get(OntObjectProperty.Named.class);
        }

        default public Set<Node> getDatatypeProperties() {
            return this.get(OntDataProperty.class);
        }

        default public Set<Node> getAnnotationProperties() {
            return this.get(OntAnnotationProperty.class);
        }

        default public Set<Node> getNamedIndividuals() {
            return this.get(OntIndividual.Named.class);
        }

        default public Set<Node> getOntProperties() {
            return this.get(OntProperty.class);
        }
    }

    public static interface Reserved
    extends ResourceVocabulary<Resource> {
        default public Set<Node> getResources() {
            return this.get(Resource.class);
        }

        default public Set<Node> getProperties() {
            return this.get(Property.class);
        }

        default public Set<Node> getAllResources() {
            return Stream.of(this.getResources(), this.getProperties()).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        }
    }

    public static interface Punnings
    extends ResourceVocabulary<OntObject> {
        default public Set<Node> getNamedClasses() {
            return this.get(OntClass.Named.class);
        }

        default public Set<Node> getDatatypes() {
            return this.get(OntDataRange.Named.class);
        }

        default public Set<Node> getObjectProperties() {
            return this.get(OntObjectProperty.Named.class);
        }

        default public Set<Node> getDatatypeProperties() {
            return this.get(OntDataProperty.class);
        }

        default public Set<Node> getAnnotationProperties() {
            return this.get(OntAnnotationProperty.class);
        }

        default public Set<Node> getNamedIndividuals() {
            return this.get(OntIndividual.Named.class);
        }
    }
}

