/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.json.JsonProvider;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.Utils;
import com.apicatalog.jsonld.serialization.GraphMap;
import com.apicatalog.jsonld.serialization.RefJsonObject;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.jsonld.uri.UriValidationPolicy;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class QuadsToJsonld
implements RdfQuadConsumer {
    protected boolean ordered = false;
    protected JsonLdOptions.RdfDirection rdfDirection = null;
    protected boolean useNativeTypes = false;
    protected boolean useRdfType = false;
    protected UriValidationPolicy uriValidation;
    protected JsonLdVersion processingMode;
    protected GraphMap graphMap = new GraphMap();
    protected Map<String, Map<String, Boolean>> compoundLiteralSubjects;
    protected Map<String, GraphMap.Reference> referenceOnce = new LinkedHashMap<String, GraphMap.Reference>();

    public QuadsToJsonld() {
        this.compoundLiteralSubjects = new LinkedHashMap<String, Map<String, Boolean>>();
        this.uriValidation = JsonLdOptions.DEFAULT_URI_VALIDATION;
        this.processingMode = JsonLdVersion.V1_1;
    }

    public QuadsToJsonld ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public QuadsToJsonld rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public QuadsToJsonld useNativeTypes(boolean useNativeTypes) {
        this.useNativeTypes = useNativeTypes;
        return this;
    }

    public QuadsToJsonld useRdfType(boolean useRdfType) {
        this.useRdfType = useRdfType;
        return this;
    }

    public QuadsToJsonld mode(JsonLdVersion processingMode) {
        this.processingMode = processingMode;
        return this;
    }

    public QuadsToJsonld uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    public QuadsToJsonld options(JsonLdOptions options) {
        this.ordered = options.isOrdered();
        this.rdfDirection = options.getRdfDirection();
        this.useNativeTypes = options.isUseNativeTypes();
        this.useRdfType = options.isUseRdfType();
        this.uriValidation = options.getUriValidation();
        this.processingMode = options.getProcessingMode();
        return this;
    }

    public QuadsToJsonld reset() {
        this.graphMap.clear();
        this.referenceOnce.clear();
        this.compoundLiteralSubjects.clear();
        return this;
    }

    public JsonArray toJsonLd() throws JsonLdError {
        for (String graphName : this.graphMap.keys()) {
            if (this.compoundLiteralSubjects.containsKey(graphName)) {
                for (String cl : this.compoundLiteralSubjects.get(graphName).keySet()) {
                    GraphMap.Reference clEntry = this.referenceOnce.get(cl);
                    if (clEntry == null) continue;
                    Optional<Map<String, JsonValue>> clNodeValue = this.graphMap.get(graphName, cl);
                    this.graphMap.remove(graphName, cl);
                    if (!clNodeValue.isPresent()) continue;
                    Map<String, JsonValue> clNode = clNodeValue.get();
                    JsonArrayBuilder clArray = JsonProvider.instance().createArrayBuilder();
                    for (JsonValue clReference : this.graphMap.get(clEntry.graphName, clEntry.subject, clEntry.property).map(JsonValue::asJsonArray).orElse(JsonValue.EMPTY_JSON_ARRAY)) {
                        JsonObject clReferenceObject;
                        if (JsonUtils.isNotObject(clReference) || !(clReferenceObject = clReference.asJsonObject()).containsKey("@id") || !cl.equals(clReference.asJsonObject().getString("@id"))) continue;
                        JsonObjectBuilder clObject = JsonProvider.instance().createObjectBuilder(clReferenceObject);
                        clObject.remove("@id");
                        clObject.add("@value", JsonUtils.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#value"), "@value"));
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#language")) {
                            JsonValue lang = JsonUtils.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#language"), "@value");
                            if (JsonUtils.isNotString(lang) || !LanguageTag.isWellFormed(((JsonString)lang).getString())) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_STRING);
                            }
                            clObject.add("@language", lang);
                        }
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction")) {
                            JsonValue direction = JsonUtils.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction"), "@value");
                            if (JsonUtils.isNotString(direction) || !"ltr".equalsIgnoreCase(((JsonString)direction).getString()) && !"rtl".equalsIgnoreCase(((JsonString)direction).getString())) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                            }
                            clObject.add("@direction", direction);
                        }
                        clArray.add(clObject);
                    }
                    this.graphMap.set(clEntry.graphName, clEntry.subject, clEntry.property, clArray.build());
                }
            }
            if (!this.graphMap.contains(graphName, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) continue;
            for (GraphMap.Reference usage : this.graphMap.getUsages(graphName, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
                Map<String, JsonValue> node = this.graphMap.get(usage.graphName, usage.subject).orElseGet(() -> Collections.emptyMap());
                JsonArrayBuilder list = JsonProvider.instance().createArrayBuilder();
                ArrayList<String> listNodes = new ArrayList<String>();
                String nodeId = ((JsonString)node.get("@id")).getString();
                while ("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest".equals(usage.property) && BlankNode.isWellFormed(nodeId) && this.referenceOnce.get(nodeId) != null && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#first") && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest") && ((JsonValue)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).asJsonArray().size() == 1 && ((JsonValue)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest")).asJsonArray().size() == 1 && (node.size() == 3 || node.size() == 4 && node.containsKey("@type") && ((JsonValue)node.get("@type")).asJsonArray().size() == 1 && ((JsonValue)node.get("@type")).asJsonArray().contains(JsonProvider.instance().createValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#List")))) {
                    list.add(0, (JsonValue)((JsonValue)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).asJsonArray().get(0));
                    listNodes.add(nodeId);
                    usage = this.referenceOnce.get(nodeId);
                    Optional<Map<String, JsonValue>> nextNode = this.graphMap.get(usage.graphName, usage.subject);
                    if (nextNode.isPresent() && (node = nextNode.get()).containsKey("@id") && !UriUtils.isAbsoluteUri(nodeId = ((JsonString)node.get("@id")).getString(), this.uriValidation)) continue;
                    break;
                }
                JsonObject head = usage.value;
                head.remove("@id");
                head.put("@list", list.build());
                listNodes.forEach(nid -> this.graphMap.remove(graphName, (String)nid));
            }
        }
        JsonArrayBuilder result = JsonProvider.instance().createArrayBuilder();
        for (String subject : Utils.index(this.graphMap.keys("@default"), this.ordered)) {
            Map node = this.graphMap.get("@default", subject).orElseGet(() -> new LinkedHashMap());
            if (this.graphMap.contains(subject)) {
                JsonArrayBuilder array = JsonProvider.instance().createArrayBuilder();
                for (String key : Utils.index(this.graphMap.keys(subject), this.ordered)) {
                    Map entry = this.graphMap.get(subject, key).orElseGet(() -> Collections.emptyMap());
                    if (entry.size() <= 1 && entry.containsKey("@id")) continue;
                    array.add(JsonUtils.toJsonObject(entry));
                }
                node.put("@graph", array.build());
            }
            if (node.size() <= 1 && node.containsKey("@id")) continue;
            result.add(JsonUtils.toJsonObject(node));
        }
        return result.build();
    }

    @Override
    public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws RdfConsumerException {
        GraphMap.Reference reference;
        String graphName;
        String string = graphName = graph == null ? "@default" : graph;
        if (direction != null || datatype != null && ((String)datatype).startsWith("https://www.w3.org/ns/i18n#")) {
            datatype = "https://www.w3.org/ns/i18n#";
            if (language != null) {
                datatype = (String)datatype + language;
                language = null;
            }
            if (direction != null) {
                datatype = (String)datatype + "_" + direction;
                direction = null;
            }
        }
        if (!this.compoundLiteralSubjects.containsKey(graphName)) {
            this.compoundLiteralSubjects.put(graphName, new LinkedHashMap());
        }
        if (!"@default".equals(graphName) && !this.graphMap.contains("@default", graphName)) {
            this.graphMap.set("@default", graphName, "@id", JsonProvider.instance().createValue(graphName));
        }
        Map<String, Boolean> compoundMap = this.compoundLiteralSubjects.get(graphName);
        if (!this.graphMap.contains(graphName, subject)) {
            this.graphMap.set(graphName, subject, "@id", JsonProvider.instance().createValue(subject));
        }
        if (JsonLdOptions.RdfDirection.COMPOUND_LITERAL == this.rdfDirection && "http://www.w3.org/1999/02/22-rdf-syntax-ns#direction".equals(predicate)) {
            compoundMap.put(subject, Boolean.TRUE);
        }
        if (!RdfQuadConsumer.isLiteral((String)datatype, language, direction) && !this.graphMap.contains(graphName, object)) {
            this.graphMap.set(graphName, object, "@id", JsonProvider.instance().createValue(object));
        }
        if (!this.useRdfType && "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(predicate) && !RdfQuadConsumer.isLiteral((String)datatype, language, direction)) {
            Optional<JsonValue> type = this.graphMap.get(graphName, subject, "@type");
            if (type.isPresent()) {
                JsonArray types = type.get().asJsonArray();
                this.graphMap.set(graphName, subject, "@type", JsonProvider.instance().createArrayBuilder(types).add(object).build());
            } else {
                this.graphMap.set(graphName, subject, "@type", JsonProvider.instance().createArrayBuilder().add(object).build());
            }
            return this;
        }
        JsonObject value = this.toObject(object, (String)datatype, language, direction);
        Optional<JsonValue> predicateValue = this.graphMap.get(graphName, subject, predicate);
        if (predicateValue.isPresent()) {
            JsonArray array = predicateValue.get().asJsonArray();
            if (!array.contains(value)) {
                this.graphMap.set(graphName, subject, predicate, JsonProvider.instance().createArrayBuilder(array).add(value).build());
            }
        } else {
            this.graphMap.set(graphName, subject, predicate, JsonProvider.instance().createArrayBuilder().add(value).build());
        }
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(object)) {
            reference = new GraphMap.Reference();
            reference.graphName = graphName;
            reference.subject = subject;
            reference.property = predicate;
            reference.value = value;
            this.graphMap.addUsage(graphName, object, reference);
        } else if (this.referenceOnce.containsKey(object)) {
            this.referenceOnce.put(object, null);
        } else if (RdfQuadConsumer.isBlank(object)) {
            reference = new GraphMap.Reference();
            reference.graphName = graphName;
            reference.subject = subject;
            reference.property = predicate;
            reference.value = value;
            this.referenceOnce.put(object, reference);
        }
        return this;
    }

    JsonObject toObject(String object, String datatype, String langTag, String direction) throws RdfConsumerException {
        String type;
        JsonValue convertedValue;
        JsonObjectBuilder result;
        block37: {
            if (!RdfQuadConsumer.isLiteral(datatype, langTag, direction)) {
                return new RefJsonObject(JsonProvider.instance().createObjectBuilder().add("@id", object).build());
            }
            result = JsonProvider.instance().createObjectBuilder();
            convertedValue = null;
            type = null;
            if (this.useNativeTypes) {
                if (datatype != null) {
                    if ("http://www.w3.org/2001/XMLSchema#string".equals(datatype)) {
                        convertedValue = JsonProvider.instance().createValue(object);
                    } else if ("http://www.w3.org/2001/XMLSchema#boolean".equals(datatype)) {
                        if ("true".equalsIgnoreCase(object)) {
                            convertedValue = JsonValue.TRUE;
                        } else if ("false".equalsIgnoreCase(object)) {
                            convertedValue = JsonValue.FALSE;
                        } else {
                            type = "http://www.w3.org/2001/XMLSchema#boolean";
                        }
                    } else if ("http://www.w3.org/2001/XMLSchema#integer".equals(datatype) || "http://www.w3.org/2001/XMLSchema#int".equals(datatype) || "http://www.w3.org/2001/XMLSchema#long".equals(datatype)) {
                        convertedValue = JsonProvider.instance().createValue(Long.parseLong(object));
                    } else if ("http://www.w3.org/2001/XMLSchema#double".equals(datatype) || "http://www.w3.org/2001/XMLSchema#float".equals(datatype)) {
                        convertedValue = JsonProvider.instance().createValue(Double.parseDouble(object));
                    } else if (datatype != null) {
                        type = datatype;
                    }
                }
            } else {
                if (this.processingMode != JsonLdVersion.V1_0 && "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON".equals(datatype)) {
                    try (JsonParser parser = JsonProvider.instance().createParser(new StringReader(object));){
                        parser.next();
                        convertedValue = parser.getValue();
                        type = "@json";
                        break block37;
                    }
                    catch (Exception e2) {
                        throw new RdfConsumerException(new JsonLdError(JsonLdErrorCode.INVALID_JSON_LITERAL, (Throwable)e2));
                    }
                }
                if (JsonLdOptions.RdfDirection.I18N_DATATYPE == this.rdfDirection && datatype != null && datatype.startsWith("https://www.w3.org/ns/i18n#")) {
                    convertedValue = JsonProvider.instance().createValue(object);
                    String dirLang = datatype.substring("https://www.w3.org/ns/i18n#".length());
                    int directionIndex = dirLang.indexOf(95);
                    if (directionIndex > 1) {
                        result.add("@language", JsonProvider.instance().createValue(dirLang.substring(0, directionIndex)));
                        result.add("@direction", JsonProvider.instance().createValue(dirLang.substring(directionIndex + 1)));
                    } else if (directionIndex == 0) {
                        result.add("@direction", JsonProvider.instance().createValue(dirLang.substring(1)));
                    } else if (directionIndex == -1) {
                        result.add("@language", JsonProvider.instance().createValue(dirLang));
                    }
                } else if (langTag != null) {
                    result.add("@language", Json.createValue(langTag));
                } else if (datatype != null && !"http://www.w3.org/2001/XMLSchema#string".equals(datatype)) {
                    type = datatype;
                }
            }
        }
        result.add("@value", convertedValue != null ? convertedValue : JsonProvider.instance().createValue(object));
        if (type != null) {
            result.add("@type", JsonProvider.instance().createValue(type));
        }
        return result.build();
    }
}

