/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.jena.atlas.lib.BitsLong;

public class DecimalNode56 {
    private static final int SCALE_LEN = 8;
    private static final int VALUE_LEN = 48;
    private static final int ENC_LEN = 56;
    private static final long MAX_VALUE = 0x7FFFFFFFFFFFL;
    private static final long MIN_VALUE = -140737488355328L;
    private static final int MAX_SCALE = 127;
    private static final int MIN_SCALE = -128;
    private static final BigInteger MAX_I = BigInteger.valueOf(0x7FFFFFFFFFFFL);
    private static final BigInteger MIN_I = BigInteger.valueOf(-140737488355328L);
    private static final int SCALE_LO = 48;
    private static final int SCALE_HI = 56;
    private static final int VALUE_LO = 0;
    private static final int VALUE_HI = 48;
    private BigDecimal decimal = null;
    private int scale;
    private long value;

    public static DecimalNode56 valueOf(BigDecimal decimal) {
        int scale = decimal.scale();
        BigInteger bigInt = decimal.unscaledValue();
        if (bigInt.compareTo(MAX_I) > 0 || bigInt.compareTo(MIN_I) < 0) {
            return null;
        }
        return DecimalNode56.valueOf(bigInt.longValue(), scale);
    }

    public static DecimalNode56 valueOf(long binValue, int scale) {
        if (scale < -128 || scale > 127) {
            return null;
        }
        if (binValue < -140737488355328L || binValue > 0x7FFFFFFFFFFFL) {
            return null;
        }
        return new DecimalNode56(binValue, scale);
    }

    private DecimalNode56(long value, int scale) {
        this.scale = scale;
        this.value = value;
    }

    public long pack() {
        return DecimalNode56.pack(this.value, this.scale);
    }

    public static long pack(long value, int scale) {
        long v = 0L;
        v = BitsLong.pack(0L, scale, 48, 56);
        v = BitsLong.pack(v, value, 0, 48);
        return v;
    }

    public static DecimalNode56 unpack(long v) {
        int scale = (int)BitsLong.unpack(v, 48, 56);
        long value = BitsLong.unpack(v, 0, 48);
        return new DecimalNode56(value, scale);
    }

    public static BigDecimal unpackAsBigDecimal(long v) {
        int scale = (int)BitsLong.unpack(v, 48, 56);
        long value = BitsLong.unpack(v, 0, 48);
        if (BitsLong.isSet(value, 47)) {
            value |= 0xFFFF000000000000L;
        }
        return BigDecimal.valueOf(value, scale);
    }

    public BigDecimal get() {
        if (this.decimal == null) {
            this.decimal = BigDecimal.valueOf(this.value, this.scale);
        }
        return this.decimal;
    }

    public String toString() {
        return this.get().toPlainString();
    }

    public int getScale() {
        return this.scale;
    }

    public long getValue() {
        return this.value;
    }
}

