/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.utils;

import org.apache.lucene.facet.MultiDoubleValuesSource;
import org.apache.lucene.facet.MultiLongValuesSource;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.sandbox.facet.cutters.ranges.DoubleRangeFacetCutter;
import org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeFacetCutter;
import org.apache.lucene.sandbox.facet.labels.RangeOrdToLabel;
import org.apache.lucene.sandbox.facet.utils.CommonFacetBuilder;

public final class RangeFacetBuilderFactory {
    private RangeFacetBuilderFactory() {
    }

    public static CommonFacetBuilder forLongRanges(String field, LongRange ... ranges) {
        return RangeFacetBuilderFactory.forLongRanges(field, MultiLongValuesSource.fromLongField(field), ranges);
    }

    public static CommonFacetBuilder forLongRanges(String dimension, MultiLongValuesSource valuesSource, LongRange ... ranges) {
        return (CommonFacetBuilder)new CommonFacetBuilder(dimension, LongRangeFacetCutter.create(valuesSource, ranges), new RangeOrdToLabel(ranges)).withSortByOrdinal();
    }

    public static CommonFacetBuilder forDoubleRanges(String field, DoubleRange ... ranges) {
        return RangeFacetBuilderFactory.forDoubleRanges(field, MultiDoubleValuesSource.fromDoubleField(field), ranges);
    }

    public static CommonFacetBuilder forDoubleRanges(String dimension, MultiDoubleValuesSource valuesSource, DoubleRange ... ranges) {
        return (CommonFacetBuilder)new CommonFacetBuilder(dimension, new DoubleRangeFacetCutter(valuesSource, ranges), new RangeOrdToLabel(ranges)).withSortByOrdinal();
    }
}

