/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import java.util.Collection;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUtils.class);

    private LdapUtils() {
    }

    public static void closeContext(LdapContext ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e2) {
            LOGGER.error("Exception while closing LDAP context. ", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getAllAttributeValues(Attribute attr) throws NamingException {
        HashSet<String> values = new HashSet<String>();
        NamingEnumeration<?> ne = null;
        try {
            ne = attr.getAll();
            while (ne.hasMore()) {
                String value = (String)ne.next();
                values.add(value);
            }
        }
        finally {
            LdapUtils.closeEnumeration(ne);
        }
        return values;
    }

    public static void closeEnumeration(NamingEnumeration ne) {
        try {
            if (ne != null) {
                ne.close();
            }
        }
        catch (NamingException e2) {
            LOGGER.error("Exception while closing NamingEnumeration: ", e2);
        }
    }
}

