/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.remote;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.http.remote.Remote;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.remote.RemoteInterface;

public class RrpcInterfaceMeta {
    private final Map<Method, RrpcInterfaceMethodMeta> methods;
    private final Map<String, RrpcInterfaceMethodMeta> methodsByPath;
    private final String path;
    private final Class<?> c;

    public RrpcInterfaceMeta(Class<?> c, String uri) {
        this.c = c;
        String path = "";
        ClassInfo ci = ClassInfo.of(c);
        for (RemoteInterface remoteInterface : ci.getAnnotations(RemoteInterface.class)) {
            if (remoteInterface.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(remoteInterface.path());
        }
        for (Remote remote : ci.getAnnotations(Remote.class)) {
            if (remote.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(remote.path());
        }
        AMap<Method, RrpcInterfaceMethodMeta> methods = AMap.of();
        for (MethodInfo m : ci.getPublicMethods()) {
            methods.put(m.inner(), new RrpcInterfaceMethodMeta(uri, m.inner()));
        }
        AMap<String, RrpcInterfaceMethodMeta> aMap = AMap.of();
        for (RrpcInterfaceMethodMeta rmm : methods.values()) {
            aMap.put(rmm.getPath(), rmm);
        }
        this.methods = methods.unmodifiable();
        this.methodsByPath = aMap.unmodifiable();
        this.path = path;
    }

    public Map<String, RrpcInterfaceMethodMeta> getMethodsByPath() {
        return this.methodsByPath;
    }

    public RrpcInterfaceMethodMeta getMethodMeta(Method m) {
        return this.methods.get(m);
    }

    public RrpcInterfaceMethodMeta getMethodMetaByPath(String p) {
        return this.methodsByPath.get(p);
    }

    public Class<?> getJavaClass() {
        return this.c;
    }

    public String getPath() {
        return this.path;
    }
}

