/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.mstat;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.mstat.ExceptionInfo;

@Bean(bpi="hash,count,exceptionClass,message,stackTrace,causedBy", fluentSetters=true)
public class ExceptionStats
extends ExceptionInfo
implements Comparable<ExceptionStats> {
    private final AtomicInteger count = new AtomicInteger(0);
    private transient long timeout = -1L;

    public static ExceptionStats create() {
        return new ExceptionStats();
    }

    public int getCount() {
        return this.count.intValue();
    }

    public ExceptionStats count(int value) {
        this.count.set(value);
        return this;
    }

    public ExceptionStats increment() {
        this.count.incrementAndGet();
        return this;
    }

    public ExceptionStats timeout(long value) {
        this.timeout = value;
        return this;
    }

    public boolean isExpired() {
        return this.timeout >= 0L && System.currentTimeMillis() > this.timeout;
    }

    @Override
    public ExceptionStats hash(String value) {
        super.hash(value);
        return this;
    }

    @Override
    public ExceptionStats exceptionClass(String value) {
        super.exceptionClass(value);
        return this;
    }

    @Override
    public ExceptionStats message(String value) {
        super.message(value);
        return this;
    }

    @Override
    public ExceptionStats stackTrace(List<StackTraceElement> value) {
        super.stackTrace(value);
        return this;
    }

    @Override
    public ExceptionStats causedBy(ExceptionInfo value) {
        super.causedBy(value);
        return this;
    }

    @Override
    public int compareTo(ExceptionStats o) {
        return Integer.compare(o.getCount(), this.getCount());
    }

    public ExceptionStats clone() {
        try {
            return (ExceptionStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

