/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.collections.OList;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.PojoRest;

public class OMap
extends ObjectMap {
    private static final long serialVersionUID = 1L;
    private transient BeanSession session;
    private Map<String, Object> inner;
    private transient PojoRest pojoRest;
    public static final OMap EMPTY_MAP = new OMap(){
        private static final long serialVersionUID = 1L;

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptyMap().entrySet();
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptyMap().keySet();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyMap().values();
        }
    };

    public OMap() {
    }

    public OMap(BeanSession session) {
        this.session = session;
    }

    public OMap(Map<?, ?> in) {
        this();
        if (in != null) {
            for (Map.Entry<?, ?> e : in.entrySet()) {
                this.put(e.getKey().toString(), e.getValue());
            }
        }
    }

    public OMap(CharSequence json) throws ParseException {
        this(json, (Parser)JsonParser.DEFAULT);
    }

    public OMap(CharSequence in, Parser p) throws ParseException {
        this(p == null ? null : p.createBeanSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        if (!StringUtils.isEmpty(in)) {
            p.parseIntoMap(in, this, this.bs().string(), this.bs().object());
        }
    }

    public OMap(Reader json) throws ParseException {
        this.parse(json, JsonParser.DEFAULT);
    }

    public OMap(Reader in, Parser p) throws ParseException {
        this(p == null ? null : p.createBeanSession());
        this.parse(in, p);
    }

    public OMap(Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new RuntimeException("Odd number of parameters passed into OMap(Object...)");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            this.put(StringUtils.stringify(keyValuePairs[i]), keyValuePairs[i + 1]);
        }
    }

    public static OMap of() {
        return new OMap();
    }

    public static OMap ofAll(Map<?, ?> in) {
        return in == null ? null : new OMap(in);
    }

    public static OMap ofJson(CharSequence json) throws ParseException {
        return json == null ? null : new OMap(json);
    }

    public static OMap ofText(CharSequence in, Parser p) throws ParseException {
        return in == null ? null : new OMap(in, p);
    }

    public static OMap ofJson(Reader json) throws ParseException {
        return json == null ? null : new OMap(json);
    }

    public static OMap ofText(Reader in, Parser p) throws ParseException {
        return in == null ? null : new OMap(in);
    }

    public static OMap of(Object ... keyValuePairs) {
        return new OMap(keyValuePairs);
    }

    public OMap inner(Map<String, Object> inner) {
        this.inner = inner;
        return this;
    }

    public OMap session(BeanSession session) {
        this.session = session;
        return this;
    }

    public OMap a(String key, Object value) {
        this.put(key, value);
        return this;
    }

    @Override
    public OMap append(String key, Object value) {
        return this.a(key, value);
    }

    public OMap aif(boolean overwrite, boolean skipNullValue, boolean skipEmptyValue, String key, Object value) {
        if (value == null && skipNullValue) {
            return this;
        }
        if (skipEmptyValue && ObjectUtils.isEmpty(value)) {
            return this;
        }
        Object current = this.get(key);
        if (current == null || overwrite) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public OMap appendIf(boolean overwrite, boolean skipNullValue, boolean skipEmptyValue, String key, Object value) {
        return this.aif(overwrite, skipNullValue, skipEmptyValue, key, value);
    }

    public OMap aif(boolean flag, String key, Object value) {
        if (flag) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public OMap appendIf(boolean flag, String key, Object value) {
        return this.aif(flag, key, value);
    }

    public OMap ase(String key, Object ... values) {
        for (Object v : values) {
            this.aif(true, true, true, key, v);
        }
        return this;
    }

    @Override
    public OMap appendSkipEmpty(String key, Object value) {
        return this.ase(key, value);
    }

    public OMap asf(String key, boolean value) {
        if (value) {
            this.a(key, value);
        }
        return this;
    }

    @Override
    public OMap appendSkipFalse(String key, boolean value) {
        return this.asf(key, value);
    }

    public OMap asmo(String key, Number ... values) {
        for (Number v : values) {
            if (v == null || v.intValue() == -1) continue;
            this.a(key, v);
        }
        return this;
    }

    @Override
    public OMap appendSkipMinusOne(String key, Number value) {
        return this.asmo(key, value);
    }

    public OMap asn(String key, Object value) {
        if (value != null) {
            this.a(key, value);
        }
        return this;
    }

    @Override
    public OMap appendSkipNull(String key, Object value) {
        return this.asn(key, value);
    }

    public OMap aa(Map<String, Object> m) {
        if (m != null) {
            this.putAll(m);
        }
        return this;
    }

    @Override
    public OMap appendAll(Map<String, Object> m) {
        if (m != null) {
            this.putAll(m);
        }
        return this;
    }

    public OMap aifn(String key, Object val) {
        Object o = this.get(key);
        if (o == null) {
            this.put(key, val);
        }
        return this;
    }

    public OMap appendIfNull(String key, Object val) {
        return this.aifn(key, val);
    }

    public OMap aife(String key, Object val) {
        Object o = this.get(key);
        if (o == null || o.toString().isEmpty()) {
            this.put(key, val);
        }
        return this;
    }

    public OMap appendIfEmpty(String key, Object val) {
        return this.aife(key, val);
    }

    public OMap aifne(String key, Object val) {
        if (!this.containsKey(key)) {
            this.put(key, val);
        }
        return this;
    }

    public OMap appendIfNotEmpty(String key, Object val) {
        return this.aifne(key, val);
    }

    public OMap aif(Predicate<Object> p, String key, Object val) {
        if (p.test(val)) {
            this.a(key, val);
        }
        return this;
    }

    public OMap appendIf(Predicate<Object> p, String key, Object val) {
        return this.aif(p, key, val);
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        return this.getWithDefault(key, null, type);
    }

    @Override
    public <T> T get(String key, Type type, Type ... args) {
        return this.getWithDefault(key, null, type, args);
    }

    @Override
    public Object getWithDefault(String key, Object def) {
        Object o = this.get(key);
        return o == null ? def : o;
    }

    @Override
    public <T> T getWithDefault(String key, T def, Class<T> type) {
        return this.getWithDefault(key, def, type, new Type[0]);
    }

    @Override
    public <T> T getWithDefault(String key, T def, Type type, Type ... args) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        Object t = this.bs().convertToType(o, type, args);
        return t == null ? def : t;
    }

    @Override
    public String findKeyIgnoreCase(String key) {
        for (String k : this.keySet()) {
            if (!key.equalsIgnoreCase(k)) continue;
            return k;
        }
        return null;
    }

    @Override
    public <T> T getSwapped(String key, PojoSwap<T, ?> pojoSwap) throws ParseException {
        try {
            Object o = super.get(key);
            if (o == null) {
                return null;
            }
            PojoSwap<T, ?> swap = pojoSwap;
            return swap.unswap(this.bs(), o, null);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Object find(String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return this.get(key);
        }
        return null;
    }

    @Override
    public <T> T find(Class<T> type, String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return this.get(key, type);
        }
        return null;
    }

    @Override
    public String getString(String key) {
        return this.get(key, String.class);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.getStringArray(key, null);
    }

    @Override
    public String[] getStringArray(String key, String[] def) {
        Object s = this.get(key, Object.class);
        if (s == null) {
            return def;
        }
        String[] r = null;
        r = s instanceof Collection ? ArrayUtils.toStringArray((Collection)s) : (s instanceof String[] ? (String[])s : (s instanceof Object[] ? ArrayUtils.toStringArray(Arrays.asList((Object[])s)) : StringUtils.split(StringUtils.stringify(s))));
        return r.length == 0 ? def : r;
    }

    @Override
    public String getString(String key, String defVal) {
        return this.getWithDefault(key, defVal, String.class);
    }

    @Override
    public Integer getInt(String key) {
        return this.get(key, Integer.class);
    }

    @Override
    public Integer getInt(String key, Integer defVal) {
        return this.getWithDefault(key, defVal, Integer.class);
    }

    @Override
    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    @Override
    public Long getLong(String key, Long defVal) {
        return this.getWithDefault(key, defVal, Long.class);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defVal) {
        return this.getWithDefault(key, defVal, Boolean.class);
    }

    public OMap getMap(String key) {
        return this.get(key, OMap.class);
    }

    public OMap getMap(String key, OMap defVal) {
        return this.getWithDefault(key, defVal, OMap.class);
    }

    public OMap getMap(String key, boolean createIfNotExists) {
        OMap m = this.getWithDefault(key, null, OMap.class);
        if (m == null && createIfNotExists) {
            m = new OMap();
            this.put(key, m);
        }
        return m;
    }

    public OList getList(String key) {
        return this.get(key, OList.class);
    }

    public OList getList(String key, OList defVal) {
        return this.getWithDefault(key, defVal, OList.class);
    }

    public OList getList(String key, boolean createIfNotExists) {
        OList m = this.getWithDefault(key, null, OList.class);
        if (m == null && createIfNotExists) {
            m = new OList();
            this.put(key, m);
        }
        return m;
    }

    @Override
    public String findString(String ... keys) {
        return this.find(String.class, keys);
    }

    @Override
    public Integer findInt(String ... keys) {
        return this.find(Integer.class, keys);
    }

    @Override
    public Long findLong(String ... keys) {
        return this.find(Long.class, keys);
    }

    @Override
    public Boolean findBoolean(String ... keys) {
        return this.find(Boolean.class, keys);
    }

    public OMap findMap(String ... keys) {
        return this.find(OMap.class, keys);
    }

    public OList findList(String ... keys) {
        return this.find(OList.class, keys);
    }

    @Override
    public String getFirstKey() {
        return this.isEmpty() ? null : this.keySet().iterator().next();
    }

    @Override
    public ClassMeta<?> getClassMeta(String key) {
        return this.bs().getClassMetaForObject(this.get(key));
    }

    @Override
    public <T> T removeWithDefault(String key, T defVal, Class<T> type) {
        T t = this.getWithDefault(key, defVal, type);
        this.remove(key);
        return t;
    }

    @Override
    public String removeString(String key) {
        return this.removeString(key, null);
    }

    @Override
    public String removeString(String key, String def) {
        return this.removeWithDefault(key, def, String.class);
    }

    @Override
    public Integer removeInt(String key) {
        return this.removeInt(key, null);
    }

    @Override
    public Integer removeInt(String key, Integer def) {
        return this.removeWithDefault(key, def, Integer.class);
    }

    @Override
    public Boolean removeBoolean(String key) {
        return this.removeBoolean(key, null);
    }

    @Override
    public Boolean removeBoolean(String key, Boolean def) {
        return this.removeWithDefault(key, def, Boolean.class);
    }

    @Override
    public void removeAll(Collection<String> keys) {
        for (String k : keys) {
            this.remove(k);
        }
    }

    @Override
    public void removeAll(String ... keys) {
        for (String k : keys) {
            this.remove(k);
        }
    }

    @Override
    public OMap keepAll(String ... keys) {
        Iterator<String> i = this.keySet().iterator();
        while (i.hasNext()) {
            boolean remove = true;
            String key = i.next();
            for (String k : keys) {
                if (!k.equals(key)) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            i.remove();
        }
        return this;
    }

    @Override
    public boolean containsKeyNotEmpty(String key) {
        Object val = this.get(key);
        if (val == null) {
            return false;
        }
        if (val instanceof CharSequence) {
            return !StringUtils.isEmpty(val);
        }
        return false;
    }

    @Override
    public boolean containsOuterKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public OMap include(String ... keys) {
        OMap m2 = new OMap();
        for (Map.Entry<String, Object> e : this.entrySet()) {
            for (String k : keys) {
                if (!k.equals(e.getKey())) continue;
                m2.put(k, e.getValue());
            }
        }
        return m2;
    }

    @Override
    public OMap exclude(String ... keys) {
        OMap m2 = new OMap();
        for (Map.Entry<String, Object> e : this.entrySet()) {
            boolean exclude = false;
            for (String k : keys) {
                if (!k.equals(e.getKey())) continue;
                exclude = true;
            }
            if (exclude) continue;
            m2.put(e.getKey(), e.getValue());
        }
        return m2;
    }

    @Override
    public <T> T cast(Class<T> type) {
        ClassMeta<T> c;
        BeanSession bs = this.bs();
        ClassMeta<T> c2 = bs.getClassMeta(type);
        String typePropertyName = bs.getBeanTypePropertyName(c2);
        ClassMeta<?> c1 = bs.getBeanRegistry().getClassMeta((String)this.get(typePropertyName));
        ClassMeta<Object> classMeta = c = c1 == null ? c2 : this.narrowClassMeta(c1, c2);
        if (c.isObject()) {
            return (T)this;
        }
        return this.cast2(c);
    }

    @Override
    public <T> T cast(ClassMeta<T> cm) {
        BeanSession bs = this.bs();
        ClassMeta<?> c1 = bs.getBeanRegistry().getClassMeta((String)this.get(bs.getBeanTypePropertyName(cm)));
        ClassMeta<?> c = this.narrowClassMeta(c1, cm);
        return (T)this.cast2(c);
    }

    @Override
    public <T> T getAt(String path, Class<T> type) {
        return this.getPojoRest().get(path, type);
    }

    @Override
    public <T> T getAt(String path, Type type, Type ... args) {
        return this.getPojoRest().get(path, type, args);
    }

    @Override
    public Object putAt(String path, Object o) {
        return this.getPojoRest().put(path, o);
    }

    @Override
    public Object postAt(String path, Object o) {
        return this.getPojoRest().post(path, o);
    }

    @Override
    public Object deleteAt(String path) {
        return this.getPojoRest().delete(path);
    }

    @Override
    public BeanSession getBeanSession() {
        return this.session;
    }

    @Override
    public void putJson(String key, String json) throws ParseException {
        this.put(key, JsonParser.DEFAULT.parse(json, Object.class));
    }

    public String asString(WriterSerializer serializer) {
        return serializer.toString(this);
    }

    public String asString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    public OMap writeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this, w);
        return this;
    }

    @Override
    public boolean isUnmodifiable() {
        return false;
    }

    @Override
    public OMap modifiable() {
        if (this.isUnmodifiable()) {
            return new OMap((Map<?, ?>)this);
        }
        return this;
    }

    @Override
    public OMap unmodifiable() {
        if (this instanceof UnmodifiableOMap) {
            return this;
        }
        return new UnmodifiableOMap(this);
    }

    private BeanSession bs() {
        if (this.session == null) {
            this.session = BeanContext.DEFAULT.createBeanSession();
        }
        return this.session;
    }

    private PojoRest getPojoRest() {
        if (this.pojoRest == null) {
            this.pojoRest = new PojoRest(this);
        }
        return this.pojoRest;
    }

    private ClassMeta<?> narrowClassMeta(ClassMeta<?> c1, ClassMeta<?> c2) {
        if (c1 == null) {
            return c2;
        }
        ClassMeta<?> c = OMap.getNarrowedClassMeta(c1, c2);
        if (c1.isMap()) {
            ClassMeta<?> k = OMap.getNarrowedClassMeta(c1.getKeyType(), c2.getKeyType());
            ClassMeta<?> v = OMap.getNarrowedClassMeta(c1.getValueType(), c2.getValueType());
            return this.bs().getClassMeta(c.getInnerClass(), k, v);
        }
        if (c1.isCollection()) {
            ClassMeta<?> e = OMap.getNarrowedClassMeta(c1.getElementType(), c2.getElementType());
            return this.bs().getClassMeta(c.getInnerClass(), e);
        }
        return c;
    }

    private static ClassMeta<?> getNarrowedClassMeta(ClassMeta<?> c1, ClassMeta<?> c2) {
        if (c2 == null || c2.getInfo().isParentOf(c1.getInnerClass())) {
            return c1;
        }
        return c2;
    }

    private <T> T cast2(ClassMeta<T> cm) {
        BeanSession bs = this.bs();
        try {
            Object value = this.get("value");
            if (cm.isMap()) {
                Map<String, Object> m2 = cm.canCreateNewInstance() ? (Map)cm.newInstance() : new OMap(bs);
                ClassMeta<?> kType = cm.getKeyType();
                ClassMeta<?> vType = cm.getValueType();
                for (Map.Entry<String, Object> e : this.entrySet()) {
                    String k = e.getKey();
                    Object v = e.getValue();
                    if (k.equals(bs.getBeanTypePropertyName(cm))) continue;
                    if (v instanceof OMap) {
                        v = ((OMap)v).cast(vType);
                    }
                    k = kType.isString() ? k : bs.convertToType((Object)k, kType);
                    v = vType.isObject() ? v : bs.convertToType(v, vType);
                    m2.put(k, v);
                }
                return (T)m2;
            }
            if (cm.isBean()) {
                BeanMap<T> bm = bs.newBeanMap(cm.getInnerClass());
                for (Map.Entry<String, Object> e : this.entrySet()) {
                    String k = e.getKey();
                    Object v = e.getValue();
                    if (k.equals(bs.getBeanTypePropertyName(cm))) continue;
                    if (v instanceof OMap) {
                        v = ((OMap)v).cast(bm.getProperty(k).getMeta().getClassMeta());
                    }
                    bm.put(k, v);
                }
                return bm.getBean();
            }
            if (cm.isCollectionOrArray()) {
                List items = (List)this.get("items");
                return bs.convertToType((Object)items, cm);
            }
            if (value != null) {
                return bs.convertToType(value, cm);
            }
        }
        catch (Exception e) {
            throw new BeanRuntimeException((Throwable)e, cm.getInnerClass(), "Error occurred attempting to cast to an object of type ''{0}''", cm.getInnerClass().getName());
        }
        throw new BeanRuntimeException(cm.getInnerClass(), "Cannot convert to class type ''{0}''.  Only beans and maps can be converted using this method.", cm.getInnerClass().getName());
    }

    private void parse(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoMap(r, this, this.bs().string(), this.bs().object());
    }

    @Override
    public Object get(Object key) {
        Object o = super.get(key);
        if (o == null && this.inner != null) {
            o = this.inner.get(key);
        }
        return o;
    }

    @Override
    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        if (this.inner != null) {
            return this.inner.containsKey(key);
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        if (this.inner == null) {
            return super.keySet();
        }
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.addAll(this.inner.keySet());
        s.addAll(super.keySet());
        return s;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.inner == null) {
            return super.entrySet();
        }
        final Set<String> keySet = this.keySet();
        final Iterator<String> keys = keySet.iterator();
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return keys.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        return new Map.Entry<String, Object>(){
                            String key;
                            {
                                this.key = (String)keys.next();
                            }

                            @Override
                            public String getKey() {
                                return this.key;
                            }

                            @Override
                            public Object getValue() {
                                return OMap.this.get(this.key);
                            }

                            @Override
                            public Object setValue(Object object) {
                                return OMap.this.put(this.key, object);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return keySet.size();
            }
        };
    }

    @Override
    public String toString() {
        return SimpleJson.DEFAULT.toString(this);
    }

    private static final class UnmodifiableOMap
    extends OMap {
        private static final long serialVersionUID = 1L;

        UnmodifiableOMap(OMap contents) {
            if (contents != null) {
                for (Map.Entry<String, Object> e : contents.entrySet()) {
                    super.put(e.getKey(), e.getValue());
                }
            }
        }

        @Override
        public final Object put(String key, Object val) {
            throw new UnsupportedOperationException("OMap is read-only.");
        }

        @Override
        public final Object remove(Object key) {
            throw new UnsupportedOperationException("OMap is read-only.");
        }

        @Override
        public final boolean isUnmodifiable() {
            return true;
        }
    }
}

