/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.cp.MessagesBuilder;
import org.apache.juneau.internal.ResourceBundleUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.marshall.SimpleJson;

public class Messages
extends ResourceBundle {
    private ResourceBundle rb;
    private Class<?> c;
    private Messages parent;
    private Locale locale;
    private final ConcurrentHashMap<Locale, Messages> localizedMessages = new ConcurrentHashMap();
    private final Map<String, String> keyMap;
    private final Set<String> rbKeys;

    public static final MessagesBuilder create(Class<?> forClass) {
        return new MessagesBuilder(forClass);
    }

    public static final Messages of(Class<?> forClass) {
        return Messages.create(forClass).build();
    }

    public static final Messages of(Class<?> forClass, String name) {
        return Messages.create(forClass).name(name).build();
    }

    public Messages(Class<?> forClass, ResourceBundle rb, Locale locale, Messages parent) {
        String shortKey;
        this.c = forClass;
        this.rb = rb;
        this.parent = parent;
        if (parent != null) {
            this.setParent(parent);
        }
        this.locale = locale == null ? Locale.getDefault() : locale;
        TreeMap<String, String> keyMap = new TreeMap<String, String>();
        String cn = this.c.getSimpleName() + '.';
        if (rb != null) {
            for (String key : rb.keySet()) {
                keyMap.put(key, key);
                if (!key.startsWith(cn)) continue;
                shortKey = key.substring(cn.length());
                keyMap.put(shortKey, key);
            }
        }
        if (parent != null) {
            for (String key : parent.keySet()) {
                keyMap.put(key, key);
                if (!key.startsWith(cn)) continue;
                shortKey = key.substring(cn.length());
                keyMap.put(shortKey, key);
            }
        }
        this.keyMap = Collections.unmodifiableMap(new LinkedHashMap(keyMap));
        this.rbKeys = rb == null ? Collections.emptySet() : rb.keySet();
    }

    public Messages forLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale.equals(locale)) {
            return this;
        }
        Messages mb = this.localizedMessages.get(locale);
        if (mb == null) {
            Messages parent = this.parent == null ? null : this.parent.forLocale(locale);
            ResourceBundle rb = this.rb == null ? null : ResourceBundleUtils.findBundle(this.rb.getBaseBundleName(), locale, this.c.getClassLoader());
            mb = new Messages(this.c, rb, locale, parent);
            this.localizedMessages.put(locale, mb);
        }
        return mb;
    }

    public Set<String> keySet(String prefix) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : this.keySet()) {
            if (!s.equals(prefix) && (!s.startsWith(prefix) || s.charAt(prefix.length()) != '.')) continue;
            set.add(s);
        }
        return set;
    }

    public String getString(String key, Object ... args) {
        String s = this.getString(key);
        if (s.startsWith("{!")) {
            return s;
        }
        return StringUtils.format(s, args);
    }

    public String findFirstString(String ... keys) {
        for (String k : keys) {
            if (!this.containsKey(k)) continue;
            return this.getString(k);
        }
        return null;
    }

    @Override
    protected Object handleGetObject(String key) {
        String k = this.keyMap.get(key);
        if (k == null) {
            return "{!" + key + "}";
        }
        try {
            if (this.rbKeys.contains(k)) {
                return this.rb.getObject(k);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.parent.handleGetObject(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.keyMap.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.keyMap.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    public String toString() {
        OMap om = new OMap();
        for (String k : new TreeSet<String>(this.keySet())) {
            om.put(k, this.getString(k));
        }
        return SimpleJson.DEFAULT.toString(om);
    }
}

