/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.collections.AList;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroupBuilder;
import org.apache.juneau.encoders.EncoderMatch;
import org.apache.juneau.encoders.GzipEncoder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.header.AcceptEncoding;

public final class EncoderGroup {
    public static final EncoderGroup DEFAULT = EncoderGroup.create().append(IdentityEncoder.class, GzipEncoder.class).build();
    private final ConcurrentHashMap<String, EncoderMatch> cache = new ConcurrentHashMap();
    private final List<String> encodings;
    private final Encoder[] encodingsEncoders;
    private final List<Encoder> encoders;

    public static EncoderGroupBuilder create() {
        return new EncoderGroupBuilder();
    }

    public EncoderGroupBuilder builder() {
        return new EncoderGroupBuilder(this);
    }

    public EncoderGroup(Encoder[] encoders) {
        this.encoders = AList.unmodifiable(encoders);
        AList lc = AList.of();
        AList l = AList.of();
        for (Encoder e : encoders) {
            for (String c : e.getCodings()) {
                lc.add(c);
                l.add(e);
            }
        }
        this.encodings = lc.unmodifiable();
        this.encodingsEncoders = l.asArrayOf(Encoder.class);
    }

    public EncoderMatch getEncoderMatch(String acceptEncoding) {
        EncoderMatch em = this.cache.get(acceptEncoding);
        if (em != null) {
            return em;
        }
        AcceptEncoding ae = AcceptEncoding.of(acceptEncoding);
        int match = ae.match(this.encodings);
        if (match >= 0) {
            em = new EncoderMatch(this.encodings.get(match), this.encodingsEncoders[match]);
            this.cache.putIfAbsent(acceptEncoding, em);
        }
        return this.cache.get(acceptEncoding);
    }

    public Encoder getEncoder(String encoding) {
        EncoderMatch em = this.getEncoderMatch(encoding);
        return em == null ? null : em.getEncoder();
    }

    public List<String> getSupportedEncodings() {
        return this.encodings;
    }

    public List<Encoder> getEncoders() {
        return this.encoders;
    }
}

