/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.internal.Cache;

@Header(value="Connection")
public class Connection
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private static final Cache<String, Connection> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static Connection of(String value) {
        if (value == null) {
            return null;
        }
        Connection x = CACHE.get(value);
        if (x == null) {
            x = CACHE.put(value, new Connection(value));
        }
        return x;
    }

    public static Connection of(Object value) {
        if (value == null) {
            return null;
        }
        return new Connection(value);
    }

    public static Connection of(Supplier<?> value) {
        if (value == null) {
            return null;
        }
        return new Connection(value);
    }

    public Connection(Object value) {
        super("Connection", value);
    }

    public Connection(String value) {
        this((Object)value);
    }

    public boolean isClose() {
        return this.eqIC("close");
    }

    public boolean isKeepAlive() {
        return this.eqIC("keep-alive");
    }

    public boolean isUpgrade() {
        return this.eqIC("upgrade");
    }
}

