/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.OList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;

public final class CollectionUtils {
    public static <T> List<T> addIfNotNull(List<T> l, T o) {
        if (o != null) {
            l.add(o);
        }
        return l;
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> e) {
        if (e == null) {
            return null;
        }
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return e.hasMoreElements();
                    }

                    @Override
                    public E next() {
                        return e.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <E> Iterator<E> iterator(final List<Iterable<E>> l) {
        return new Iterator<E>(){
            Iterator<Iterable<E>> i1;
            Iterator<E> i2;
            {
                this.i1 = l.iterator();
                this.i2 = this.i1.hasNext() ? this.i1.next().iterator() : null;
            }

            @Override
            public boolean hasNext() {
                while (this.i2 != null && !this.i2.hasNext()) {
                    this.i2 = this.i1.hasNext() ? this.i1.next().iterator() : null;
                }
                return this.i2 != null;
            }

            @Override
            public E next() {
                this.hasNext();
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                return this.i2.next();
            }

            @Override
            public void remove() {
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                this.i2.remove();
            }
        };
    }

    public static <T> List<T> addToList(List<T> appendTo, Object[] values, Class<T> type, Type ... args) {
        if (values == null) {
            return appendTo;
        }
        try {
            List<T> l = appendTo;
            if (appendTo == null) {
                l = new ArrayList<T>();
            }
            for (Object o : values) {
                if (o == null) continue;
                if (StringUtils.isJsonArray(o, false)) {
                    for (Object o2 : new OList(o.toString())) {
                        l.add(ConverterUtils.toType(o2, type, args));
                    }
                    continue;
                }
                if (o instanceof Collection) {
                    for (Object o2 : (Collection)o) {
                        l.add(ConverterUtils.toType(o2, type, args));
                    }
                    continue;
                }
                if (o.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        l.add(ConverterUtils.toType(Array.get(o, i), type, args));
                    }
                    continue;
                }
                l.add(ConverterUtils.toType(o, type, args));
            }
            return l.isEmpty() ? null : l;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> appendTo, Object[] values, Class<K> keyType, Class<V> valueType, Type ... valueTypeArgs) {
        if (values == null) {
            return appendTo;
        }
        try {
            Map<K, V> m = appendTo;
            if (m == null) {
                m = new LinkedHashMap();
            }
            for (Object o : values) {
                if (o == null) continue;
                if (StringUtils.isJsonObject(o, false)) {
                    for (Map.Entry<String, Object> entry : OMap.ofJson(o.toString()).entrySet()) {
                        m.put(ConverterUtils.toType(entry.getKey(), keyType), ConverterUtils.toType(entry.getValue(), valueType, valueTypeArgs));
                    }
                    continue;
                }
                if (o instanceof Map) {
                    for (Map.Entry<String, Object> entry : ((Map)o).entrySet()) {
                        m.put(ConverterUtils.toType(entry.getKey(), keyType), ConverterUtils.toType(entry.getValue(), valueType, valueTypeArgs));
                    }
                    continue;
                }
                throw new BasicRuntimeException("Invalid object type {0} passed to addToMap()", o.getClass().getName());
            }
            return m.isEmpty() ? null : m;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> AList<T> newList(Collection<T> val) {
        return AList.nullable(val);
    }

    public static <T> List<T> addToList(List<T> l, Collection<T> val) {
        if (val != null) {
            if (l == null) {
                l = new ArrayList<T>(val);
            } else {
                l.addAll(val);
            }
        }
        return l;
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> val) {
        if (val == null) {
            return null;
        }
        return new LinkedHashMap<K, V>(val);
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> m, Map<K, V> val) {
        if (val != null) {
            if (m == null) {
                m = new LinkedHashMap<K, V>(val);
            } else {
                m.putAll(val);
            }
        }
        return m;
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> m, K key, V value) {
        if (m == null) {
            m = new LinkedHashMap();
        }
        m.put(key, value);
        return m;
    }

    public static <K, V> Map<K, V> newSortedMap(Map<K, V> val, Comparator<K> comparator) {
        if (val == null) {
            return null;
        }
        TreeMap<K, V> m = new TreeMap<K, V>(comparator);
        m.putAll(val);
        return m;
    }

    public static Set<String> newSortedCaseInsensitiveSet(String ... values) {
        TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean contains(Object v) {
                return v == null ? false : super.contains(v);
            }
        };
        for (String v : values) {
            if (v == null) continue;
            s.add(v);
        }
        return s;
    }

    public static Set<String> newSortedCaseInsensitiveSet(String values) {
        return CollectionUtils.newSortedCaseInsensitiveSet(StringUtils.split(StringUtils.emptyIfNull(values)));
    }

    public static Set<String> newUnmodifiableSortedCaseInsensitiveSet(String values) {
        return Collections.unmodifiableSet(CollectionUtils.newSortedCaseInsensitiveSet(StringUtils.split(StringUtils.emptyIfNull(values))));
    }

    public static <K, V> Map<K, V> addToSortedMap(Map<K, V> m, Map<K, V> val, Comparator<K> comparator) {
        if (val != null) {
            if (m == null) {
                m = new TreeMap(comparator);
                m.putAll(val);
            } else {
                m.putAll(val);
            }
        }
        return m;
    }

    public static <K, V> Map<K, V> addToSortedMap(Map<K, V> m, K key, V value, Comparator<K> comparator) {
        if (m == null) {
            m = new TreeMap(comparator);
        }
        m.put(key, value);
        return m;
    }

    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static <T> T last(List<T> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.get(l.size() - 1);
    }
}

