/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;

@Response
public class StaticFile {
    private final byte[] contents;
    private final String mediaType;
    private final Map<String, Object> headers;

    public StaticFile(byte[] contents, String mediaType, Map<String, Object> headers) {
        this.contents = contents;
        this.mediaType = mediaType;
        this.headers = headers;
    }

    public boolean exists() {
        return this.contents != null;
    }

    @ResponseHeader(value="*")
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @ResponseBody
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.contents);
    }

    @ResponseHeader(value="Content-Type")
    public String getContentType() {
        return this.mediaType == null ? null : this.mediaType.toString();
    }
}

