/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client2;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client2.RestCallException;
import org.apache.juneau.rest.client2.RestCallInterceptor;
import org.apache.juneau.rest.client2.RestClient;
import org.apache.juneau.rest.client2.RestRequest;
import org.apache.juneau.rest.client2.RestResponseBody;
import org.apache.juneau.rest.client2.RestResponseHeader;
import org.apache.juneau.rest.client2.RestResponseStatusLineAssertion;
import org.apache.juneau.utils.Mutable;

public class RestResponse
implements HttpResponse {
    private final RestClient client;
    private final RestRequest request;
    private final HttpResponse response;
    private final Parser parser;
    HttpPartParserSession partParser;
    private RestResponseBody responseBody;
    private boolean isClosed;

    protected RestResponse(RestClient client, RestRequest request, HttpResponse response, Parser parser) {
        this.client = client;
        this.request = request;
        this.parser = parser;
        this.response = response == null ? new BasicHttpResponse(null, 0, null) : response;
        this.responseBody = new RestResponseBody(client, request, this, parser);
        this.partParser = client.getPartParserSession();
    }

    public RestRequest getRequest() {
        return this.request;
    }

    public RestResponse consume() throws RestCallException {
        this.close();
        return this;
    }

    public RestResponse getStatusLine(Mutable<StatusLine> m) {
        m.set(this.getStatusLine());
        return this;
    }

    public int getStatusCode() {
        return this.getStatusLine().getStatusCode();
    }

    public RestResponse getStatusCode(Mutable<Integer> m) {
        m.set(this.getStatusCode());
        return this;
    }

    public String getReasonPhrase() {
        return this.getStatusLine().getReasonPhrase();
    }

    public RestResponse getReasonPhrase(Mutable<String> m) {
        m.set(this.getReasonPhrase());
        return this;
    }

    public RestResponseStatusLineAssertion assertStatus() throws RestCallException {
        return new RestResponseStatusLineAssertion(this.getStatusLine(), this);
    }

    public FluentIntegerAssertion<RestResponse> assertCode() throws RestCallException {
        return this.assertStatus().code();
    }

    public String getStringHeader(String name) {
        return this.getHeader(name).asString();
    }

    public String getStringHeader(String name, String def) {
        return this.getHeader(name).asStringOrElse(def);
    }

    public RestResponseHeader getHeader(String name) {
        return new RestResponseHeader(this.request, this, this.getLastHeader(name)).parser(this.partParser);
    }

    public String getCharacterEncoding() throws RestCallException {
        String s = this.getContentType().getParameter("charset");
        return StringUtils.isEmpty(s) ? "utf-8" : s;
    }

    public ContentType getContentType() throws RestCallException {
        return this.getHeader("Content-Type").as(ContentType.class);
    }

    public FluentStringAssertion<RestResponse> assertStringHeader(String name) {
        return this.getHeader(name).assertString();
    }

    public FluentIntegerAssertion<RestResponse> assertIntegerHeader(String name) {
        return this.getHeader(name).assertInteger();
    }

    public FluentLongAssertion<RestResponse> assertLongHeader(String name) {
        return this.getHeader(name).assertLong();
    }

    public FluentZonedDateTimeAssertion<RestResponse> assertDateHeader(String name) {
        return this.getHeader(name).assertDate();
    }

    public FluentListAssertion<RestResponse> assertCsvArrayHeader(String name) {
        return this.getHeader(name).assertCsvArray();
    }

    public FluentStringAssertion<RestResponse> assertCharset() throws RestCallException {
        return new FluentStringAssertion<RestResponse>(this.getCharacterEncoding(), this);
    }

    public FluentStringAssertion<RestResponse> assertContentType() {
        return this.getHeader("Content-Type").assertString();
    }

    public RestResponseBody getBody() {
        return this.responseBody;
    }

    public FluentStringAssertion<RestResponse> assertBody() throws RestCallException {
        return this.responseBody.cache().assertString();
    }

    public FluentByteArrayAssertion<RestResponse> assertBodyBytes() throws RestCallException {
        return this.responseBody.cache().assertBytes();
    }

    public FluentObjectAssertion<RestResponse> assertBody(Class<?> type) throws RestCallException {
        return this.responseBody.cache().assertObject(type);
    }

    public RestResponse cacheBody() {
        this.responseBody.cache();
        return this;
    }

    <T> T as(final ResponseBeanMeta rbm) {
        Class<?> c = rbm.getClassMeta().getInnerClass();
        final RestClient rc = this.client;
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ResponseBeanPropertyMeta pm = rbm.getProperty(method.getName());
                HttpPartParserSession pp = pm.getParser(RestResponse.this.partParser);
                HttpPartSchema schema = pm.getSchema();
                HttpPartType pt = pm.getPartType();
                String name = pm.getPartName();
                ClassMeta type = rc.getClassMeta(method.getGenericReturnType(), new Type[0]);
                if (pt == HttpPartType.RESPONSE_HEADER) {
                    return RestResponse.this.getHeader(name).parser(pp).schema(schema).as(type);
                }
                if (pt == HttpPartType.RESPONSE_STATUS) {
                    return RestResponse.this.getStatusCode();
                }
                return RestResponse.this.getBody().schema(schema).as(type);
            }
        });
    }

    public RestResponse log(Level level, Throwable t, String msg, Object ... args) {
        this.client.log(level, t, msg, args);
        return this;
    }

    public RestResponse log(Level level, String msg, Object ... args) {
        this.client.log(level, msg, args);
        return this;
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public void setStatusLine(StatusLine statusline) {
        this.response.setStatusLine(statusline);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.response.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.response.setStatusLine(ver, code, reason);
    }

    public void setStatusCode(int code) {
        this.response.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) {
        this.response.setReasonPhrase(reason);
    }

    public RestResponseBody getEntity() {
        return this.responseBody;
    }

    public void setEntity(HttpEntity entity) {
        this.response.setEntity(entity);
        this.responseBody = new RestResponseBody(this.client, this.request, this, this.parser);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.response.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public RestResponseHeader[] getHeaders(String name) {
        Header[] a = this.response.getHeaders(name);
        RestResponseHeader[] b = new RestResponseHeader[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = new RestResponseHeader(this.request, this, a[i]).parser(this.partParser);
        }
        return b;
    }

    public RestResponseHeader getFirstHeader(String name) {
        Header h = this.response.getFirstHeader(name);
        return h == null ? null : new RestResponseHeader(this.request, this, h).parser(this.partParser);
    }

    public RestResponseHeader getLastHeader(String name) {
        Header h = this.response.getLastHeader(name);
        return h == null ? null : new RestResponseHeader(this.request, this, h).parser(this.partParser);
    }

    public RestResponseHeader[] getAllHeaders() {
        Header[] a = this.response.getAllHeaders();
        RestResponseHeader[] b = new RestResponseHeader[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = new RestResponseHeader(this.request, this, a[i]).parser(this.partParser);
        }
        return b;
    }

    public void addHeader(Header header) {
        this.response.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.response.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.response.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.response.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.response.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        return this.response.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.response.headerIterator(name);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.response.getParams();
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.response.setParams(params);
    }

    void close() throws RestCallException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        if (this.request.isDebug() || this.client.logRequestsPredicate.test(this.request, this)) {
            if (this.client.logRequests == DetailLevel.SIMPLE) {
                this.client.log(this.client.logRequestsLevel, "HTTP {0} {1}, {2}", this.request.getMethod(), this.request.getURI(), this.getStatusLine());
            } else if (this.request.isDebug() || this.client.logRequests == DetailLevel.FULL) {
                String output = this.getBody().asString();
                StringBuilder sb = new StringBuilder();
                sb.append("\n=== HTTP Call (outgoing) ======================================================");
                sb.append("\n=== REQUEST ===\n");
                sb.append(this.request.getMethod()).append(" ").append(this.request.getURI());
                sb.append("\n---request headers---");
                for (Header header : this.request.getAllHeaders()) {
                    sb.append("\n\t").append(header);
                }
                if (this.request.hasHttpEntity()) {
                    sb.append("\n---request entity---");
                    RestResponseHeader[] e = this.request.getHttpEntity();
                    if (e.getContentType() != null) {
                        sb.append("\n\t").append(e.getContentType());
                    }
                    if (e.isRepeatable()) {
                        try {
                            sb.append("\n---request content---\n").append(EntityUtils.toString((HttpEntity)e));
                        }
                        catch (Exception ex) {
                            sb.append("\n---request content exception---\n").append(ex.getMessage());
                        }
                    }
                }
                sb.append("\n=== RESPONSE ===\n").append(this.getStatusLine());
                sb.append("\n---response headers---");
                for (RestResponseHeader restResponseHeader : this.getAllHeaders()) {
                    sb.append("\n\t").append(restResponseHeader);
                }
                sb.append("\n---response content---\n").append(output);
                sb.append("\n=== END =======================================================================");
                this.client.log(this.client.logRequestsLevel, sb.toString(), new Object[0]);
            }
        }
        for (RestCallInterceptor r : this.request.interceptors) {
            try {
                r.onClose(this.request, this);
            }
            catch (RuntimeException | RestCallException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestCallException(this, e, "Interceptor throw exception on close", new Object[0]);
            }
        }
        this.client.onClose(this.request, this);
    }

    HttpResponse asHttpResponse() {
        return this.response;
    }
}

