/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.juneau.ContextRuntimeException;
import org.apache.juneau.Value;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.annotation.AnnotationUtils;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;

public class HttpPartSchemaBuilder {
    String name;
    String _default;
    Set<Integer> codes;
    Set<String> _enum;
    Boolean allowEmptyValue;
    Boolean exclusiveMaximum;
    Boolean exclusiveMinimum;
    Boolean required;
    Boolean uniqueItems;
    Boolean skipIfEmpty;
    HttpPartCollectionFormat collectionFormat = HttpPartCollectionFormat.NO_COLLECTION_FORMAT;
    HttpPartDataType type = HttpPartDataType.NO_TYPE;
    HttpPartFormat format = HttpPartFormat.NO_FORMAT;
    Pattern pattern;
    Number maximum;
    Number minimum;
    Number multipleOf;
    Long maxLength;
    Long minLength;
    Long maxItems;
    Long minItems;
    Long maxProperties;
    Long minProperties;
    Map<String, Object> properties;
    Object items;
    Object additionalProperties;
    boolean noValidate;
    Class<? extends HttpPartParser> parser;
    Class<? extends HttpPartSerializer> serializer;

    public HttpPartSchema build() {
        return new HttpPartSchema(this);
    }

    HttpPartSchemaBuilder apply(Class<? extends Annotation> c, ParamInfo mpi) {
        this.apply(c, mpi.getParameterType().innerType());
        for (Annotation a : mpi.getDeclaredAnnotations()) {
            if (!c.isInstance(a)) continue;
            this.apply(a);
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Class<? extends Annotation> c, Method m) {
        this.apply(c, m.getGenericReturnType());
        Annotation a = m.getAnnotation(c);
        if (a != null) {
            return this.apply(a);
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Class<? extends Annotation> c, Type t) {
        if (t instanceof Class) {
            ClassInfo ci = ClassInfo.of((Class)t);
            for (Annotation annotation : ci.getAnnotations(c)) {
                this.apply(annotation);
            }
        } else if (Value.isType(t)) {
            this.apply(c, Value.getParameterType(t));
        }
        return this;
    }

    public HttpPartSchemaBuilder apply(Annotation a) {
        if (a instanceof Body) {
            this.apply((Body)a);
        } else if (a instanceof Header) {
            this.apply((Header)a);
        } else if (a instanceof FormData) {
            this.apply((FormData)a);
        } else if (a instanceof Query) {
            this.apply((Query)a);
        } else if (a instanceof Path) {
            this.apply((Path)a);
        } else if (a instanceof Response) {
            this.apply((Response)a);
        } else if (a instanceof ResponseHeader) {
            this.apply((ResponseHeader)a);
        } else if (a instanceof HasQuery) {
            this.apply((HasQuery)a);
        } else if (a instanceof HasFormData) {
            this.apply((HasFormData)a);
        } else if (a instanceof Schema) {
            this.apply((Schema)a);
        } else {
            throw new RuntimeException("HttpPartSchemaBuilder.apply(@" + a.getClass().getSimpleName() + ") not defined");
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Body a) {
        this.required(a.required() || a.r());
        this.allowEmptyValue(!a.required() && !a.r());
        this.apply(a.schema());
        return this;
    }

    HttpPartSchemaBuilder apply(Header a) {
        this.name(StringUtils.firstNonEmpty(a.name(), a.n(), a.value()));
        this.required(a.required() || a.r());
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.allowEmptyValue(a.allowEmptyValue() || a.aev());
        this.items(a.items());
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this._default(this.joinnlOrNull(a._default(), a.df()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        this.skipIfEmpty(a.skipIfEmpty() || a.sie());
        this.parser(a.parser());
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(ResponseHeader a) {
        this.name(StringUtils.firstNonEmpty(a.name(), a.n(), a.value()));
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.items(a.items());
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this._default(this.joinnlOrNull(a._default(), a.df()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        this.allowEmptyValue(false);
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(FormData a) {
        this.name(StringUtils.firstNonEmpty(a.name(), a.n(), a.value()));
        this.required(a.required() || a.r());
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.allowEmptyValue(a.allowEmptyValue() || a.aev());
        this.items(a.items());
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this._default(this.joinnlOrNull(a._default(), a.df()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        this.skipIfEmpty(a.skipIfEmpty() || a.sie());
        this.parser(a.parser());
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(Query a) {
        this.name(StringUtils.firstNonEmpty(a.name(), a.n(), a.value()));
        this.required(a.required() || a.r());
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.allowEmptyValue(a.allowEmptyValue() || a.aev());
        this.items(a.items());
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this._default(this.joinnlOrNull(a._default(), a.df()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        this.skipIfEmpty(a.skipIfEmpty() || a.sie());
        this.parser(a.parser());
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(Path a) {
        this.name(StringUtils.firstNonEmpty(a.name(), a.n(), a.value()));
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.items(a.items());
        this.allowEmptyValue(a.allowEmptyValue() || a.aev());
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        this.parser(a.parser());
        this.serializer(a.serializer());
        if (StringUtils.startsWith(this.name, '/')) {
            this.allowEmptyValue();
            this.required(false);
        } else {
            this.required(a.required() && a.r());
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Response a) {
        this.codes(a.value());
        this.codes(a.code());
        this.required(false);
        this.allowEmptyValue(true);
        this.serializer(a.serializer());
        this.parser(a.parser());
        this.apply(a.schema());
        return this;
    }

    HttpPartSchemaBuilder apply(Items a) {
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.items(a.items());
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this._default(this.joinnlOrNull(a._default(), a.df()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        return this;
    }

    HttpPartSchemaBuilder apply(SubItems a) {
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.items(HttpPartSchema.toOMap(a.items()));
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this._default(this.joinnlOrNull(a._default(), a.df()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        return this;
    }

    HttpPartSchemaBuilder apply(Schema a) {
        this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
        this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
        this.items(a.items());
        this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
        this._default(this.joinnlOrNull(a._default(), a.df()));
        this.maximum(this.toNumber(a.maximum(), a.max()));
        this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
        this.minimum(this.toNumber(a.minimum(), a.min()));
        this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
        this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
        this.minLength(this.firstNmo(a.minLength(), a.minl()));
        this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
        this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
        this.minItems(this.firstNmo(a.minItems(), a.mini()));
        this.uniqueItems(a.uniqueItems() || a.ui());
        this._enum(this.toSet(a._enum(), a.e()));
        this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
        this.maxProperties(this.firstNmo(a.maxProperties(), a.maxp()));
        this.minProperties(this.firstNmo(a.minProperties(), a.minp()));
        this.properties(HttpPartSchema.toOMap(a.properties()));
        this.additionalProperties(HttpPartSchema.toOMap(a.additionalProperties()));
        return this;
    }

    HttpPartSchemaBuilder apply(HasQuery a) {
        this.name(StringUtils.firstNonEmpty(a.name(), a.n(), a.value()));
        return this;
    }

    HttpPartSchemaBuilder apply(HasFormData a) {
        this.name(StringUtils.firstNonEmpty(a.name(), a.n(), a.value()));
        return this;
    }

    HttpPartSchemaBuilder apply(OMap m) {
        if (m != null && !m.isEmpty()) {
            this._default(m.getString("default"));
            this._enum(HttpPartSchema.toSet(m.getString("enum")));
            this.allowEmptyValue(m.getBoolean("allowEmptyValue"));
            this.exclusiveMaximum(m.getBoolean("exclusiveMaximum"));
            this.exclusiveMinimum(m.getBoolean("exclusiveMinimum"));
            this.required(m.getBoolean("required"));
            this.uniqueItems(m.getBoolean("uniqueItems"));
            this.collectionFormat(m.getString("collectionFormat"));
            this.type(m.getString("type"));
            this.format(m.getString("format"));
            this.pattern(m.getString("pattern"));
            this.maximum(m.get("maximum", Number.class));
            this.minimum(m.get("minimum", Number.class));
            this.multipleOf(m.get("multipleOf", Number.class));
            this.maxItems(m.get("maxItems", Long.class));
            this.maxLength(m.get("maxLength", Long.class));
            this.maxProperties(m.get("maxProperties", Long.class));
            this.minItems(m.get("minItems", Long.class));
            this.minLength(m.get("minLength", Long.class));
            this.minProperties(m.get("minProperties", Long.class));
            this.items(m.getMap("items"));
            this.properties(m.getMap("properties"));
            this.additionalProperties(m.getMap("additionalProperties"));
            this.apply(m.getMap("schema", (OMap)null));
        }
        return this;
    }

    public HttpPartSchemaBuilder name(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.name = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder n(String value) {
        return this.name(value);
    }

    public HttpPartSchemaBuilder codes(int[] value) {
        if (value != null && value.length != 0) {
            for (int v : value) {
                this.code(v);
            }
        }
        return this;
    }

    public HttpPartSchemaBuilder code(int value) {
        if (value != 0) {
            if (this.codes == null) {
                this.codes = new TreeSet<Integer>();
            }
            this.codes.add(value);
        }
        return this;
    }

    public HttpPartSchemaBuilder required(Boolean value) {
        this.required = this.resolve(value, this.required);
        return this;
    }

    public HttpPartSchemaBuilder r(Boolean value) {
        return this.required(value);
    }

    public HttpPartSchemaBuilder required(String value) {
        this.required = this.resolve(value, this.required);
        return this;
    }

    public HttpPartSchemaBuilder r(String value) {
        return this.required(value);
    }

    public HttpPartSchemaBuilder required() {
        return this.required(true);
    }

    public HttpPartSchemaBuilder r() {
        return this.required();
    }

    public HttpPartSchemaBuilder type(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.type = HttpPartDataType.fromString(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException("Invalid value ''{0}'' passed in as type value.  Valid values: {1}", new Object[]{value, HttpPartDataType.values()});
        }
        return this;
    }

    public HttpPartSchemaBuilder t(String value) {
        return this.type(value);
    }

    public HttpPartSchemaBuilder tString() {
        this.type = HttpPartDataType.STRING;
        return this;
    }

    public HttpPartSchemaBuilder tNumber() {
        this.type = HttpPartDataType.NUMBER;
        return this;
    }

    public HttpPartSchemaBuilder tInteger() {
        this.type = HttpPartDataType.INTEGER;
        return this;
    }

    public HttpPartSchemaBuilder tBoolean() {
        this.type = HttpPartDataType.BOOLEAN;
        return this;
    }

    public HttpPartSchemaBuilder tArray() {
        this.type = HttpPartDataType.ARRAY;
        return this;
    }

    public HttpPartSchemaBuilder tObject() {
        this.type = HttpPartDataType.OBJECT;
        return this;
    }

    public HttpPartSchemaBuilder tFile() {
        this.type = HttpPartDataType.FILE;
        return this;
    }

    public HttpPartSchemaBuilder tNone() {
        this.type = HttpPartDataType.NO_TYPE;
        return this;
    }

    public HttpPartSchemaBuilder type(HttpPartDataType value) {
        this.type = value;
        return this;
    }

    public HttpPartSchemaBuilder t(HttpPartDataType value) {
        return this.type(value);
    }

    public HttpPartSchemaBuilder format(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.format = HttpPartFormat.fromString(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException("Invalid value ''{0}'' passed in as format value.  Valid values: {1}", new Object[]{value, HttpPartFormat.values()});
        }
        return this;
    }

    public HttpPartSchemaBuilder f(String value) {
        return this.format(value);
    }

    public HttpPartSchemaBuilder format(HttpPartFormat value) {
        this.format = value;
        return this;
    }

    public HttpPartSchemaBuilder f(HttpPartFormat value) {
        return this.format(value);
    }

    public HttpPartSchemaBuilder fInt32() {
        this.format = HttpPartFormat.INT32;
        return this;
    }

    public HttpPartSchemaBuilder fInt64() {
        this.format = HttpPartFormat.INT64;
        return this;
    }

    public HttpPartSchemaBuilder fFloat() {
        this.format = HttpPartFormat.FLOAT;
        return this;
    }

    public HttpPartSchemaBuilder fDouble() {
        this.format = HttpPartFormat.DOUBLE;
        return this;
    }

    public HttpPartSchemaBuilder fByte() {
        this.format = HttpPartFormat.BYTE;
        return this;
    }

    public HttpPartSchemaBuilder fBinary() {
        this.format = HttpPartFormat.BINARY;
        return this;
    }

    public HttpPartSchemaBuilder fBinarySpaced() {
        this.format = HttpPartFormat.BINARY_SPACED;
        return this;
    }

    public HttpPartSchemaBuilder fDate() {
        this.format = HttpPartFormat.DATE;
        return this;
    }

    public HttpPartSchemaBuilder fDateTime() {
        this.format = HttpPartFormat.DATE_TIME;
        return this;
    }

    public HttpPartSchemaBuilder fPassword() {
        this.format = HttpPartFormat.PASSWORD;
        return this;
    }

    public HttpPartSchemaBuilder fUon() {
        this.format = HttpPartFormat.UON;
        return this;
    }

    public HttpPartSchemaBuilder fNone() {
        this.format = HttpPartFormat.NO_FORMAT;
        return this;
    }

    public HttpPartSchemaBuilder allowEmptyValue(Boolean value) {
        this.allowEmptyValue = this.resolve(value, this.allowEmptyValue);
        return this;
    }

    public HttpPartSchemaBuilder aev(Boolean value) {
        return this.allowEmptyValue(value);
    }

    public HttpPartSchemaBuilder allowEmptyValue(String value) {
        this.allowEmptyValue = this.resolve(value, this.allowEmptyValue);
        return this;
    }

    public HttpPartSchemaBuilder aev(String value) {
        return this.allowEmptyValue(value);
    }

    public HttpPartSchemaBuilder allowEmptyValue() {
        return this.allowEmptyValue(true);
    }

    public HttpPartSchemaBuilder aev() {
        return this.allowEmptyValue(true);
    }

    public HttpPartSchemaBuilder items(HttpPartSchemaBuilder value) {
        if (value != null) {
            this.items = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder i(HttpPartSchemaBuilder value) {
        return this.items(value);
    }

    public HttpPartSchemaBuilder items(HttpPartSchema value) {
        if (value != null) {
            this.items = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder i(HttpPartSchema value) {
        return this.items(value);
    }

    HttpPartSchemaBuilder items(OMap value) {
        if (value != null && !value.isEmpty()) {
            this.items = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    HttpPartSchemaBuilder items(Items value) {
        if (!AnnotationUtils.empty(value)) {
            this.items = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    HttpPartSchemaBuilder items(SubItems value) {
        if (!AnnotationUtils.empty(value)) {
            this.items = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    public HttpPartSchemaBuilder collectionFormat(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.collectionFormat = HttpPartCollectionFormat.fromString(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException("Invalid value ''{0}'' passed in as collectionFormat value.  Valid values: {1}", new Object[]{value, HttpPartCollectionFormat.values()});
        }
        return this;
    }

    public HttpPartSchemaBuilder cf(String value) {
        return this.collectionFormat(value);
    }

    public HttpPartSchemaBuilder collectionFormat(HttpPartCollectionFormat value) {
        this.collectionFormat = value;
        return this;
    }

    public HttpPartSchemaBuilder cf(HttpPartCollectionFormat value) {
        return this.collectionFormat(value);
    }

    public HttpPartSchemaBuilder cfCsv() {
        return this.collectionFormat(HttpPartCollectionFormat.CSV);
    }

    public HttpPartSchemaBuilder cfSsv() {
        return this.collectionFormat(HttpPartCollectionFormat.SSV);
    }

    public HttpPartSchemaBuilder cfTsv() {
        return this.collectionFormat(HttpPartCollectionFormat.TSV);
    }

    public HttpPartSchemaBuilder cfPipes() {
        return this.collectionFormat(HttpPartCollectionFormat.PIPES);
    }

    public HttpPartSchemaBuilder cfMulti() {
        return this.collectionFormat(HttpPartCollectionFormat.MULTI);
    }

    public HttpPartSchemaBuilder cfUon() {
        return this.collectionFormat(HttpPartCollectionFormat.UONC);
    }

    public HttpPartSchemaBuilder cfNone() {
        return this.collectionFormat(HttpPartCollectionFormat.NO_COLLECTION_FORMAT);
    }

    public HttpPartSchemaBuilder _default(String value) {
        if (value != null) {
            this._default = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder df(String value) {
        return this._default(value);
    }

    public HttpPartSchemaBuilder maximum(Number value) {
        if (value != null) {
            this.maximum = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder max(Number value) {
        return this.maximum(value);
    }

    public HttpPartSchemaBuilder exclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = this.resolve(value, this.exclusiveMaximum);
        return this;
    }

    public HttpPartSchemaBuilder emax(Boolean value) {
        return this.exclusiveMaximum(value);
    }

    public HttpPartSchemaBuilder exclusiveMaximum(String value) {
        this.exclusiveMaximum = this.resolve(value, this.exclusiveMaximum);
        return this;
    }

    public HttpPartSchemaBuilder emax(String value) {
        return this.exclusiveMaximum(value);
    }

    public HttpPartSchemaBuilder exclusiveMaximum() {
        return this.exclusiveMaximum(true);
    }

    public HttpPartSchemaBuilder emax() {
        return this.exclusiveMaximum();
    }

    public HttpPartSchemaBuilder minimum(Number value) {
        if (value != null) {
            this.minimum = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder min(Number value) {
        return this.minimum(value);
    }

    public HttpPartSchemaBuilder exclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = this.resolve(value, this.exclusiveMinimum);
        return this;
    }

    public HttpPartSchemaBuilder emin(Boolean value) {
        return this.exclusiveMinimum(value);
    }

    public HttpPartSchemaBuilder exclusiveMinimum(String value) {
        this.exclusiveMinimum = this.resolve(value, this.exclusiveMinimum);
        return this;
    }

    public HttpPartSchemaBuilder emin(String value) {
        return this.exclusiveMinimum(value);
    }

    public HttpPartSchemaBuilder exclusiveMinimum() {
        return this.exclusiveMinimum(true);
    }

    public HttpPartSchemaBuilder emin() {
        return this.exclusiveMinimum();
    }

    public HttpPartSchemaBuilder maxLength(Long value) {
        this.maxLength = this.resolve(value, this.maxLength);
        return this;
    }

    public HttpPartSchemaBuilder maxl(Long value) {
        return this.maxLength(value);
    }

    public HttpPartSchemaBuilder maxLength(String value) {
        this.maxLength = this.resolve(value, this.maxLength);
        return this;
    }

    public HttpPartSchemaBuilder maxl(String value) {
        return this.maxLength(value);
    }

    public HttpPartSchemaBuilder minLength(Long value) {
        this.minLength = this.resolve(value, this.minLength);
        return this;
    }

    public HttpPartSchemaBuilder minl(Long value) {
        return this.minLength(value);
    }

    public HttpPartSchemaBuilder minLength(String value) {
        this.minLength = this.resolve(value, this.minLength);
        return this;
    }

    public HttpPartSchemaBuilder minl(String value) {
        return this.minLength(value);
    }

    public HttpPartSchemaBuilder pattern(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.pattern = Pattern.compile(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException(e, "Invalid value {0} passed in as pattern value.  Must be a valid regular expression.", value);
        }
        return this;
    }

    public HttpPartSchemaBuilder p(String value) {
        return this.pattern(value);
    }

    public HttpPartSchemaBuilder maxItems(Long value) {
        this.maxItems = this.resolve(value, this.maxItems);
        return this;
    }

    public HttpPartSchemaBuilder maxi(Long value) {
        return this.maxItems(value);
    }

    public HttpPartSchemaBuilder maxItems(String value) {
        this.maxItems = this.resolve(value, this.maxItems);
        return this;
    }

    public HttpPartSchemaBuilder maxi(String value) {
        return this.maxItems(value);
    }

    public HttpPartSchemaBuilder minItems(Long value) {
        this.minItems = this.resolve(value, this.minItems);
        return this;
    }

    public HttpPartSchemaBuilder mini(Long value) {
        return this.minItems(value);
    }

    public HttpPartSchemaBuilder minItems(String value) {
        this.minItems = this.resolve(value, this.minItems);
        return this;
    }

    public HttpPartSchemaBuilder mini(String value) {
        return this.minItems(value);
    }

    public HttpPartSchemaBuilder uniqueItems(Boolean value) {
        this.uniqueItems = this.resolve(value, this.uniqueItems);
        return this;
    }

    public HttpPartSchemaBuilder ui(Boolean value) {
        return this.uniqueItems(value);
    }

    public HttpPartSchemaBuilder uniqueItems(String value) {
        this.uniqueItems = this.resolve(value, this.uniqueItems);
        return this;
    }

    public HttpPartSchemaBuilder ui(String value) {
        return this.uniqueItems(value);
    }

    public HttpPartSchemaBuilder uniqueItems() {
        return this.uniqueItems(true);
    }

    public HttpPartSchemaBuilder ui() {
        return this.uniqueItems();
    }

    public HttpPartSchemaBuilder skipIfEmpty(Boolean value) {
        this.skipIfEmpty = this.resolve(value, this.skipIfEmpty);
        return this;
    }

    public HttpPartSchemaBuilder sie(Boolean value) {
        return this.skipIfEmpty(value);
    }

    public HttpPartSchemaBuilder skipIfEmpty(String value) {
        this.skipIfEmpty = this.resolve(value, this.skipIfEmpty);
        return this;
    }

    public HttpPartSchemaBuilder sie(String value) {
        return this.skipIfEmpty(value);
    }

    public HttpPartSchemaBuilder skipIfEmpty() {
        return this.skipIfEmpty(true);
    }

    public HttpPartSchemaBuilder sie() {
        return this.skipIfEmpty();
    }

    public HttpPartSchemaBuilder _enum(Set<String> value) {
        if (value != null && !value.isEmpty()) {
            this._enum = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder e(Set<String> value) {
        return this._enum(value);
    }

    public HttpPartSchemaBuilder _enum(String ... values) {
        return this._enum(ASet.of(values));
    }

    public HttpPartSchemaBuilder e(String ... values) {
        return this._enum(values);
    }

    public HttpPartSchemaBuilder multipleOf(Number value) {
        if (value != null) {
            this.multipleOf = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder mo(Number value) {
        return this.multipleOf(value);
    }

    public HttpPartSchemaBuilder maxProperties(Long value) {
        this.maxProperties = this.resolve(value, this.maxProperties);
        return this;
    }

    public HttpPartSchemaBuilder maxp(Long value) {
        return this.maxProperties(value);
    }

    public HttpPartSchemaBuilder maxProperties(String value) {
        this.maxProperties = this.resolve(value, this.maxProperties);
        return this;
    }

    public HttpPartSchemaBuilder maxp(String value) {
        return this.maxProperties(value);
    }

    public HttpPartSchemaBuilder minProperties(Long value) {
        this.minProperties = this.resolve(value, this.minProperties);
        return this;
    }

    public HttpPartSchemaBuilder minp(Long value) {
        return this.minProperties(value);
    }

    public HttpPartSchemaBuilder minProperties(String value) {
        this.minProperties = this.resolve(value, this.minProperties);
        return this;
    }

    public HttpPartSchemaBuilder minp(String value) {
        return this.minProperties(value);
    }

    public HttpPartSchemaBuilder property(String key, HttpPartSchemaBuilder value) {
        if (key != null && value != null) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
            this.properties.put(key, value);
        }
        return this;
    }

    public HttpPartSchemaBuilder property(String key, HttpPartSchema value) {
        if (key != null && value != null) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
            this.properties.put(key, value);
        }
        return this;
    }

    public HttpPartSchemaBuilder p(String key, HttpPartSchemaBuilder value) {
        return this.property(key, value);
    }

    public HttpPartSchemaBuilder p(String key, HttpPartSchema value) {
        return this.property(key, value);
    }

    private HttpPartSchemaBuilder properties(OMap value) {
        if (value != null && !value.isEmpty()) {
            for (Map.Entry<String, Object> e : value.entrySet()) {
                this.property(e.getKey(), HttpPartSchema.create().apply((OMap)e.getValue()));
            }
        }
        return this;
    }

    public HttpPartSchemaBuilder additionalProperties(HttpPartSchemaBuilder value) {
        if (value != null) {
            this.additionalProperties = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder additionalProperties(HttpPartSchema value) {
        if (value != null) {
            this.additionalProperties = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder ap(HttpPartSchemaBuilder value) {
        return this.additionalProperties(value);
    }

    public HttpPartSchemaBuilder ap(HttpPartSchema value) {
        return this.additionalProperties(value);
    }

    private HttpPartSchemaBuilder additionalProperties(OMap value) {
        if (value != null && !value.isEmpty()) {
            this.additionalProperties = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    public HttpPartSchemaBuilder serializer(Class<? extends HttpPartSerializer> value) {
        if (value != null && value != HttpPartSerializer.Null.class) {
            this.serializer = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder parser(Class<? extends HttpPartParser> value) {
        if (value != null && value != HttpPartParser.Null.class) {
            this.parser = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder noValidate(Boolean value) {
        if (value != null) {
            this.noValidate = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder noValidate() {
        return this.noValidate(true);
    }

    private Boolean resolve(String newValue, Boolean oldValue) {
        return StringUtils.isEmpty(newValue) ? oldValue : Boolean.valueOf(newValue);
    }

    private Boolean resolve(Boolean newValue, Boolean oldValue) {
        return newValue == null ? oldValue : newValue;
    }

    private Long resolve(String newValue, Long oldValue) {
        return StringUtils.isEmpty(newValue) ? oldValue : Long.parseLong(newValue);
    }

    private Long resolve(Long newValue, Long oldValue) {
        return newValue == null || newValue == -1L ? oldValue : newValue;
    }

    private Set<String> toSet(String[] ... s) {
        return HttpPartSchema.toSet(s);
    }

    private Number toNumber(String ... s) {
        return HttpPartSchema.toNumber(s);
    }

    private Long firstNmo(Long ... l) {
        for (Long ll : l) {
            if (ll == null || ll == -1L) continue;
            return ll;
        }
        return null;
    }

    private String joinnlOrNull(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length <= 0) continue;
            return StringUtils.joinnl(objectArray);
        }
        return null;
    }
}

