/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.http.BasicHttpEntity;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.NoCloseOutputStream;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class SerializedHttpEntity
extends BasicHttpEntity {
    private final Serializer serializer;
    private HttpPartSchema schema;

    public static SerializedHttpEntity of(Object content, Serializer serializer) {
        return new SerializedHttpEntity(content, serializer);
    }

    public static SerializedHttpEntity of(Supplier<?> content, Serializer serializer) {
        return new SerializedHttpEntity(content, serializer);
    }

    public SerializedHttpEntity(Object content, Serializer serializer) {
        super(content, ContentType.of(serializer == null ? null : serializer.getResponseContentType()), null);
        this.serializer = serializer;
    }

    @FluentSetter
    public SerializedHttpEntity schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.isSerializable()) {
            try {
                os = new NoCloseOutputStream(os);
                Object o = this.getRawContent();
                if (this.serializer == null) {
                    os.write(o.toString().getBytes());
                    os.close();
                }
                SerializerSessionArgs sArgs = SerializerSessionArgs.create().schema(this.schema);
                SerializerSession session = this.serializer.createSession(sArgs);
                try (Closeable c = session.isWriterSerializer() ? new OutputStreamWriter(os, IOUtils.UTF8) : os;){
                    session.serialize(o, c);
                }
            }
            catch (SerializeException e) {
                throw new BasicRuntimeException(e, "Serialization error on request body.", new Object[0]);
            }
        } else {
            super.writeTo(os);
        }
    }

    @Override
    public boolean isRepeatable() {
        if (this.isSerializable()) {
            return true;
        }
        return super.isRepeatable();
    }

    @Override
    public long getContentLength() {
        if (this.isSerializable()) {
            return -1L;
        }
        return super.getContentLength();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getContent() {
        if (!this.isSerializable()) return super.getContent();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.writeTo(baos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSerializable() {
        Object o = this.getRawContent();
        return !(o instanceof InputStream) && !(o instanceof Reader) && !(o instanceof File);
    }

    @Override
    public SerializedHttpEntity cache() {
        super.cache();
        return this;
    }

    @Override
    public SerializedHttpEntity cache(boolean value) {
        super.cache(value);
        return this;
    }

    @Override
    public SerializedHttpEntity chunked() {
        super.chunked();
        return this;
    }

    @Override
    public SerializedHttpEntity chunked(boolean value) {
        super.chunked(value);
        return this;
    }

    @Override
    public SerializedHttpEntity contentEncoding(String value) {
        super.contentEncoding(value);
        return this;
    }

    @Override
    public SerializedHttpEntity contentEncoding(Header value) {
        super.contentEncoding(value);
        return this;
    }

    @Override
    public SerializedHttpEntity contentLength(long value) {
        super.contentLength(value);
        return this;
    }

    @Override
    public SerializedHttpEntity contentType(String value) {
        super.contentType(value);
        return this;
    }

    @Override
    public SerializedHttpEntity contentType(Header value) {
        super.contentType(value);
        return this;
    }
}

