/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public enum ShareAcquireMode {
    BATCH_OPTIMIZED("batch_optimized", 0),
    RECORD_LIMIT("record_limit", 1);

    public final String name;
    final byte id;

    private ShareAcquireMode(String name, byte id) {
        this.name = name;
        this.id = id;
    }

    public static ShareAcquireMode of(String name) {
        if (name == null) {
            throw new IllegalArgumentException("ShareAcquireMode is null");
        }
        try {
            return ShareAcquireMode.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value `" + name + "` for configuration " + name + ". The value must either be 'batch_optimized' or 'record_limit'.");
        }
    }

    public byte id() {
        return this.id;
    }

    public static ShareAcquireMode forId(byte id) {
        switch (id) {
            case 0: {
                return BATCH_OPTIMIZED;
            }
            case 1: {
                return RECORD_LIMIT;
            }
        }
        throw new IllegalArgumentException("Unknown share acquire mode id: " + id);
    }

    public String toString() {
        return this.name;
    }

    public static class Validator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            String acquireMode = (String)value;
            try {
                ShareAcquireMode.of(acquireMode);
            }
            catch (Exception e) {
                throw new ConfigException(name, value, "Invalid value `" + acquireMode + "` for configuration " + name + ". The value must either be 'batch_optimized' or 'record_limit'.");
            }
        }

        public String toString() {
            String values = Arrays.stream(ShareAcquireMode.values()).map(ShareAcquireMode::toString).collect(Collectors.joining(", "));
            return "[" + values + "]";
        }
    }
}

