/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.server.common.OffsetAndEpoch;

public record MetadataImage(MetadataProvenance provenance, FeaturesImage features, ClusterImage cluster, TopicsImage topics, ConfigurationsImage configs, ClientQuotasImage clientQuotas, ProducerIdsImage producerIds, AclsImage acls, ScramImage scram, DelegationTokenImage delegationTokens) {
    public static final MetadataImage EMPTY = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY);

    public boolean isEmpty() {
        return this.features.isEmpty() && this.cluster.isEmpty() && this.topics.isEmpty() && this.configs.isEmpty() && this.clientQuotas.isEmpty() && this.producerIds.isEmpty() && this.acls.isEmpty() && this.scram.isEmpty() && this.delegationTokens.isEmpty();
    }

    public OffsetAndEpoch highestOffsetAndEpoch() {
        return new OffsetAndEpoch(this.provenance.lastContainedOffset(), this.provenance.lastContainedEpoch());
    }

    public long offset() {
        return this.provenance.lastContainedOffset();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        this.features.write(writer, options);
        this.cluster.write(writer, options);
        this.topics.write(writer, options);
        this.configs.write(writer);
        this.clientQuotas.write(writer);
        this.producerIds.write(writer);
        this.acls.write(writer);
        this.scram.write(writer, options);
        this.delegationTokens.write(writer, options);
        writer.close(true);
    }

    @Override
    public String toString() {
        return new MetadataImageNode(this).stringify();
    }
}

