/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.SttySupport;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class PtyCapableChannelSession
extends ChannelSession {
    public static final int DEFAULT_COLUMNS_COUNT = 80;
    public static final int DEFAULT_ROWS_COUNT = 24;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    public static final Map<PtyMode, Integer> DEFAULT_PTY_MODES = GenericUtils.mapBuilder().put(PtyMode.ISIG, 1).put(PtyMode.ICANON, 1).put(PtyMode.ECHO, 1).put(PtyMode.ECHOE, 1).put(PtyMode.ECHOK, 1).put(PtyMode.ECHONL, 0).put(PtyMode.NOFLSH, 0).immutable();
    private boolean agentForwarding;
    private boolean usePty;
    private String ptyType;
    private int ptyColumns = 80;
    private int ptyLines = 24;
    private int ptyWidth = 640;
    private int ptyHeight = 480;
    private Map<PtyMode, Integer> ptyModes = new EnumMap<PtyMode, Integer>(PtyMode.class);
    private final Map<String, String> env = new LinkedHashMap<String, String>();

    public PtyCapableChannelSession(boolean usePty) {
        this.usePty = usePty;
        this.ptyType = System.getenv("TERM");
        if (GenericUtils.isEmpty(this.ptyType)) {
            this.ptyType = "dummy";
        }
        this.ptyModes.putAll(DEFAULT_PTY_MODES);
    }

    public void setupSensibleDefaultPty() {
        try {
            if (OsUtils.isUNIX()) {
                this.ptyModes = SttySupport.getUnixPtyModes();
                this.ptyColumns = SttySupport.getTerminalWidth();
                this.ptyLines = SttySupport.getTerminalHeight();
            } else {
                this.ptyType = "windows";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAgentForwarding() {
        return this.agentForwarding;
    }

    public void setAgentForwarding(boolean agentForwarding) {
        this.agentForwarding = agentForwarding;
    }

    public boolean isUsePty() {
        return this.usePty;
    }

    public void setUsePty(boolean usePty) {
        this.usePty = usePty;
    }

    public String getPtyType() {
        return this.ptyType;
    }

    public void setPtyType(String ptyType) {
        this.ptyType = ptyType;
    }

    public int getPtyColumns() {
        return this.ptyColumns;
    }

    public void setPtyColumns(int ptyColumns) {
        this.ptyColumns = ptyColumns;
    }

    public int getPtyLines() {
        return this.ptyLines;
    }

    public void setPtyLines(int ptyLines) {
        this.ptyLines = ptyLines;
    }

    public int getPtyWidth() {
        return this.ptyWidth;
    }

    public void setPtyWidth(int ptyWidth) {
        this.ptyWidth = ptyWidth;
    }

    public int getPtyHeight() {
        return this.ptyHeight;
    }

    public void setPtyHeight(int ptyHeight) {
        this.ptyHeight = ptyHeight;
    }

    public Map<PtyMode, Integer> getPtyModes() {
        return this.ptyModes;
    }

    public void setPtyModes(Map<PtyMode, Integer> ptyModes) {
        this.ptyModes = ptyModes == null ? Collections.emptyMap() : ptyModes;
    }

    public void setEnv(String key, String value) {
        this.env.put(key, value);
    }

    public void sendWindowChange(int columns, int lines) throws IOException {
        this.sendWindowChange(columns, lines, this.ptyHeight, this.ptyWidth);
    }

    public void sendWindowChange(int columns, int lines, int height, int width) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWindowChange({}) cols={}, lines={}, height={}, width={}", new Object[]{this, columns, lines, height, width});
        }
        this.ptyColumns = columns;
        this.ptyLines = lines;
        this.ptyHeight = height;
        this.ptyWidth = width;
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)98, 64);
        buffer.putInt(this.getRecipient());
        buffer.putString("window-change");
        buffer.putBoolean(false);
        buffer.putInt(this.ptyColumns);
        buffer.putInt(this.ptyLines);
        buffer.putInt(this.ptyHeight);
        buffer.putInt(this.ptyWidth);
        this.writePacket(buffer);
    }

    protected void doOpenPty() throws IOException {
        Session session = this.getSession();
        if (this.agentForwarding) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doOpenPty({}) Send agent forwarding request", (Object)this);
            }
            String channelType = session.getStringProperty("ssh-agent-factory-proxy-auth-channel-type", "auth-agent-req@openssh.com");
            Buffer buffer = session.createBuffer((byte)98, 64);
            buffer.putInt(this.getRecipient());
            buffer.putString(channelType);
            buffer.putBoolean(false);
            this.writePacket(buffer);
        }
        if (this.usePty) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doOpenPty({}) Send SSH_MSG_CHANNEL_REQUEST pty-req: type={}, cols={}, lines={}, height={}, width={}, modes={}", new Object[]{this, this.ptyType, this.ptyColumns, this.ptyLines, this.ptyHeight, this.ptyWidth, this.ptyModes});
            }
            Buffer buffer = session.createBuffer((byte)98, 127);
            buffer.putInt(this.getRecipient());
            buffer.putString("pty-req");
            buffer.putBoolean(false);
            buffer.putString(this.ptyType);
            buffer.putInt(this.ptyColumns);
            buffer.putInt(this.ptyLines);
            buffer.putInt(this.ptyHeight);
            buffer.putInt(this.ptyWidth);
            ByteArrayBuffer modes = new ByteArrayBuffer(GenericUtils.size(this.ptyModes) * 5 + 64, false);
            this.ptyModes.forEach((mode, value) -> {
                modes.putByte((byte)mode.toInt());
                modes.putInt(value.longValue());
            });
            ((Buffer)modes).putByte((byte)0);
            buffer.putBytes(modes.getCompactData());
            this.writePacket(buffer);
        }
        if (GenericUtils.size(this.env) > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doOpenPty({}) Send SSH_MSG_CHANNEL_REQUEST env: {}", (Object)this, this.env);
            }
            for (Map.Entry<String, String> entry : this.env.entrySet()) {
                String key = entry.getKey();
                String value2 = entry.getValue();
                Buffer buffer = session.createBuffer((byte)98, key.length() + value2.length() + 32);
                buffer.putInt(this.getRecipient());
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(key);
                buffer.putString(value2);
                this.writePacket(buffer);
            }
        }
    }
}

