/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.apache.karaf.shell.ssh.KnownHostsManager;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;

public class ServerKeyVerifierImpl
implements ServerKeyVerifier {
    private final KnownHostsManager knownHostsManager;
    private final boolean quiet;
    private static final String keyChangedMessage = " @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n @    WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!      @ \n @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \nIT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!\nSomeone could be eavesdropping on you right now (man-in-the-middle attack)!\nIt is also possible that the RSA host key has just been changed.\nPlease contact your system administrator.\nAdd correct host key in " + System.getProperty("user.home") + "/.sshkaraf/known_hosts to get rid of this message.\nOffending key in " + System.getProperty("user.home") + "/.sshkaraf/known_hosts\nRSA host key has changed and you have requested strict checking.\nHost key verification failed.";

    public ServerKeyVerifierImpl(KnownHostsManager knownHostsManager, boolean quiet) {
        this.knownHostsManager = knownHostsManager;
        this.quiet = quiet;
    }

    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        PublicKey knownKey;
        try {
            knownKey = this.knownHostsManager.getKnownKey(remoteAddress, serverKey.getAlgorithm());
        }
        catch (InvalidKeySpecException e) {
            System.err.println("Invalid key stored for host " + remoteAddress + ". Terminating session.");
            return false;
        }
        if (knownKey == null) {
            boolean confirm;
            if (!this.quiet) {
                System.out.println("Connecting to unknown server. Add this server to known hosts ? (y/n)");
                confirm = this.getConfirmation();
            } else {
                System.out.println("Connecting to unknown server. Automatically adding to known hosts.");
                confirm = true;
            }
            if (confirm) {
                this.knownHostsManager.storeKeyForHost(remoteAddress, serverKey);
                System.out.println("Storing the server key in known_hosts.");
            } else {
                System.out.println("Aborting connection");
            }
            return confirm;
        }
        boolean verifed = knownKey.equals(serverKey);
        if (!verifed) {
            System.err.println("Server key for host " + remoteAddress + " does not match the stored key !! Terminating session.");
            System.err.println(keyChangedMessage);
        }
        return verifed;
    }

    private boolean getConfirmation() {
        int ch;
        try {
            while ((ch = System.in.read()) != 121 && ch != 110) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean confirm = ch == 121;
        return confirm;
    }
}

