/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.differ;

import aQute.bnd.differ.DiffImpl;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Tree;
import aQute.bnd.service.diff.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class Element
implements Tree {
    static final Element[] EMPTY = new Element[0];
    final Type type;
    final String name;
    final Delta add;
    final Delta remove;
    final String comment;
    final Element[] children;

    Element(Type type, String name) {
        this(type, name, null, Delta.MINOR, Delta.MAJOR, null);
    }

    Element(Type type, String name, Element ... children) {
        this(type, name, Arrays.asList(children), Delta.MINOR, Delta.MAJOR, null);
    }

    Element(Type type, String name, List<Element> children) {
        this(type, name, children, Delta.MINOR, Delta.MAJOR, null);
    }

    Element(Type type, String name, Collection<? extends Element> children, Delta add, Delta remove, String comment) {
        this.type = type;
        this.name = name;
        this.add = add;
        this.remove = remove;
        this.comment = comment;
        this.children = children == null || children.isEmpty() ? EMPTY : (Element[])children.stream().sorted().toArray(Element[]::new);
    }

    public Element(Tree.Data data) {
        this.name = data.name;
        this.type = data.type;
        this.comment = data.comment;
        this.add = data.add;
        this.remove = data.rem;
        this.children = data.children == null || data.children.length == 0 ? EMPTY : (Element[])Arrays.stream(data.children).map(Element::new).sorted().toArray(Element[]::new);
    }

    @Override
    public Tree.Data serialize() {
        Tree.Data data = new Tree.Data();
        data.type = this.getType();
        data.name = this.getName();
        data.add = this.ifAdded();
        data.rem = this.ifRemoved();
        data.comment = this.getComment();
        data.children = (Tree.Data[])Arrays.stream(this.getChildren()).map(Element::serialize).toArray(Tree.Data[]::new);
        return data;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    String getComment() {
        return this.comment;
    }

    @Override
    public int compareTo(Tree other) {
        if (this.getType() == other.getType()) {
            return this.getName().compareTo(other.getName());
        }
        return this.getType().compareTo(other.getType());
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((Element)other) == 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getName()});
    }

    public Element[] getChildren() {
        return this.children;
    }

    @Override
    public Delta ifAdded() {
        return this.add;
    }

    @Override
    public Delta ifRemoved() {
        return this.remove;
    }

    @Override
    public Diff diff(Tree older) {
        return new DiffImpl(this, older);
    }

    @Override
    public Element get(String name) {
        for (Element e : this.getChildren()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "");
        return sb.toString();
    }

    private void toString(StringBuilder sb, String indent) {
        sb.append(indent).append((Object)this.getType()).append(" ").append(this.getName()).append(" (").append((Object)this.ifAdded()).append("/").append((Object)this.ifRemoved()).append(")").append("\n");
        for (Element e : this.getChildren()) {
            e.toString(sb, indent + " ");
        }
    }
}

