/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.osgi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.karaf.shell.api.action.lifecycle.Manager;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.History;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.action.command.ManagerImpl;
import org.apache.karaf.shell.impl.action.osgi.AggregateServiceTracker;
import org.apache.karaf.shell.impl.action.osgi.RegistryImpl;
import org.apache.karaf.shell.support.converter.GenericType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandExtension.class);
    private final Bundle bundle;
    private final Registry registry;
    private final CountDownLatch started;
    private final AggregateServiceTracker tracker;
    private final List<Class> classes = new ArrayList<Class>();
    private Manager manager;

    public CommandExtension(Bundle bundle, Registry registry) {
        this.bundle = bundle;
        this.registry = registry;
        this.started = new CountDownLatch(1);
        this.tracker = new AggregateServiceTracker(bundle.getBundleContext()){

            @Override
            protected void updateState(AggregateServiceTracker.State state) {
                CommandExtension.this.updateState(state);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        try {
            String header = (String)this.bundle.getHeaders().get("Karaf-Commands");
            Clause[] clauses = Parser.parseHeader(header);
            BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
            for (Clause clause : clauses) {
                Object name = clause.getName();
                int options = 2;
                if (((String)(name = ((String)name).replace('.', '/'))).endsWith("*")) {
                    options |= 1;
                    name = ((String)name).substring(0, ((String)name).length() - 1);
                }
                if (!((String)name).startsWith("/")) {
                    name = "/" + (String)name;
                }
                if (((String)name).endsWith("/")) {
                    name = ((String)name).substring(0, ((String)name).length() - 1);
                }
                Collection classes = wiring.listResources((String)name, "*.class", options);
                for (String className : classes) {
                    className = className.replace('/', '.').replace(".class", "");
                    try {
                        this.inspectClass(this.bundle.loadClass(className));
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError ex) {
                        LOGGER.info("Inspection of class {} failed.", (Object)className, (Object)ex);
                    }
                }
            }
            AggregateServiceTracker.State state = this.tracker.open();
            if (!state.isSatisfied()) {
                LOGGER.info("Command registration delayed for bundle {}/{}. Missing service: {}", new Object[]{this.bundle.getSymbolicName(), this.bundle.getVersion(), state.getMissingServices()});
            } else {
                this.updateState(state);
            }
        }
        finally {
            this.started.countDown();
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.started.getCount() > 0L) {
                this.started.await(5000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("The wait for bundle " + this.bundle.getSymbolicName() + " being started before destruction has been interrupted.", (Throwable)e);
        }
        this.tracker.close();
    }

    private synchronized void updateState(AggregateServiceTracker.State state) {
        String action;
        boolean isSatisfied;
        boolean wasSatisfied = this.manager != null;
        boolean bl = isSatisfied = state != null && state.isSatisfied();
        if (wasSatisfied && isSatisfied) {
            action = "Updating";
        } else if (wasSatisfied) {
            action = "Unregistering";
        } else if (isSatisfied) {
            action = "Registering";
        } else {
            return;
        }
        LOGGER.info("{} commands for bundle {}/{}", new Object[]{action, this.bundle.getSymbolicName(), this.bundle.getVersion()});
        if (wasSatisfied) {
            for (Class clazz : this.classes) {
                this.manager.unregister(clazz);
            }
            this.manager = null;
        }
        if (isSatisfied) {
            RegistryImpl reg = new RegistryImpl(this.registry);
            this.manager = new ManagerImpl(reg, this.registry);
            reg.register(this.bundle.getBundleContext());
            reg.register(this.manager);
            for (Map.Entry<Class, Object> entry : state.getSingleServices().entrySet()) {
                reg.register(entry.getValue());
            }
            for (Map.Entry<Class, Object> entry : state.getMultiServices().entrySet()) {
                reg.register(entry::getValue, entry.getKey());
            }
            for (Class clazz : this.classes) {
                this.manager.register(clazz);
            }
        }
    }

    private void inspectClass(Class<?> clazz) throws Exception {
        Service reg = clazz.getAnnotation(Service.class);
        if (reg == null) {
            return;
        }
        for (Class<?> cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            for (Field field : cl.getDeclaredFields()) {
                Class<?> clazzRef;
                Reference ref = field.getAnnotation(Reference.class);
                if (ref == null) continue;
                GenericType type = new GenericType(field.getGenericType());
                Class<?> clazz2 = clazzRef = type.getRawClass() == List.class ? type.getActualTypeArgument(0).getRawClass() : type.getRawClass();
                if (clazzRef == BundleContext.class || clazzRef == Session.class || clazzRef == Terminal.class || clazzRef == History.class || clazzRef == Registry.class || clazzRef == SessionFactory.class || this.registry.hasService(clazzRef)) continue;
                this.track(type, ref.optional(), ref.filter());
            }
        }
        this.classes.add(clazz);
    }

    protected void track(GenericType type, boolean optional, String filter) {
        if (type.getRawClass() == List.class) {
            Class<?> clazzRef = type.getActualTypeArgument(0).getRawClass();
            this.tracker.trackList(clazzRef, filter);
        } else {
            Class<?> clazzRef = type.getRawClass();
            this.tracker.trackSingle(clazzRef, optional, filter);
        }
    }
}

