/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.config.impl;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnectionFactory;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryRegistration
implements Closeable {
    static final String CONNECTION_FACTORY_TYPE = "connectionFactoryType";
    static final String MANAGED_CF = "pax.jms.managed";
    static final String JNDI_SERVICE_NAME = "osgi.jndi.service.name";
    private static final Set<String> NOT_FORWARDED_KEYS = new HashSet<String>(Arrays.asList("name", "type", "connectionFactoryType"));
    private static final Set<String> FORWARDED_KEY_PREFIXES = new HashSet<String>(Arrays.asList("pool.", "factory."));
    private static final String CONFIG_KEY_PREFIX = "jms.";
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionFactoryRegistration.class);
    private AutoCloseable connectionFactory;
    private ServiceRegistration<ConnectionFactory> serviceReg;

    public ConnectionFactoryRegistration(BundleContext context, ConnectionFactoryFactory cff, Dictionary<String, Object> config, Dictionary<String, Object> decryptedConfig) {
        String cfName = ConnectionFactoryRegistration.getCFName(config);
        if (cfName != null) {
            config.put(JNDI_SERVICE_NAME, cfName);
        }
        try {
            LOG.info("Found ConnectionFactoryFactory. Creating ConnectionFactory {}", (Object)cfName);
            String typeName = (String)config.get(CONNECTION_FACTORY_TYPE);
            Class<?> type = this.getType(typeName);
            Object cf = this.createCF(cff, type, decryptedConfig);
            if (cf instanceof AutoCloseable) {
                this.connectionFactory = (AutoCloseable)cf;
            }
            Dictionary serviceProperties = this.filterHidden(config);
            serviceProperties.put(MANAGED_CF, "true");
            this.serviceReg = context.registerService(type.getName(), cf, serviceProperties);
        }
        catch (JMSRuntimeException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static String getCFName(Dictionary<String, Object> config) {
        String jndiName = (String)config.get(JNDI_SERVICE_NAME);
        String cfName = (String)config.get("name");
        if (cfName == null && jndiName == null) {
            throw new IllegalStateException("Can not determine ConnectionFactory name. Must set osgi.jndi.service.name or name");
        }
        return jndiName != null ? jndiName : cfName;
    }

    @Override
    public void close() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
        }
        this.safeClose(this.connectionFactory);
    }

    private Class<?> getType(String typeName) {
        if (typeName == null || ConnectionFactory.class.getSimpleName().equals(typeName)) {
            return ConnectionFactory.class;
        }
        if (XAConnectionFactory.class.getSimpleName().equals(typeName)) {
            return XAConnectionFactory.class;
        }
        String msg = String.format("Problem in ConnectionFactory config: %s must be one of %s, %s", CONNECTION_FACTORY_TYPE, ConnectionFactory.class.getSimpleName(), XAConnectionFactory.class.getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    private Object createCF(ConnectionFactoryFactory cff, Class<?> type, Dictionary<String, Object> decryptedConfig) throws JMSRuntimeException {
        Objects.requireNonNull(cff, "Must provide a ConnectionFactoryFactory");
        Map<String, Object> props = this.toMap(decryptedConfig);
        if (type == ConnectionFactory.class) {
            return cff.createConnectionFactory(props);
        }
        return cff.createXAConnectionFactory(props);
    }

    private Map<String, Object> toMap(Dictionary<String, Object> dict) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration<String> keys = dict.keys();
        while (keys.hasMoreElements()) {
            String originalKey = keys.nextElement();
            String unhiddenKey = this.unhide(originalKey);
            if (this.shouldForwardToConnectionFactoryFactory(unhiddenKey)) {
                props.put(unhiddenKey, dict.get(originalKey));
                continue;
            }
            if (!unhiddenKey.startsWith(CONFIG_KEY_PREFIX)) continue;
            props.put(unhiddenKey.substring(CONFIG_KEY_PREFIX.length()), dict.get(originalKey));
        }
        return props;
    }

    private boolean shouldForwardToConnectionFactoryFactory(String key) {
        boolean shouldForward = !key.contains(".") && !NOT_FORWARDED_KEYS.contains(key);
        Iterator<String> it = FORWARDED_KEY_PREFIXES.iterator();
        while (!shouldForward && it.hasNext()) {
            shouldForward = key.startsWith(it.next());
        }
        return shouldForward;
    }

    private Dictionary filterHidden(Dictionary dict) {
        Hashtable filtered = new Hashtable(dict.size());
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.isHidden(key)) continue;
            ((Dictionary)filtered).put(key, dict.get(key));
        }
        return filtered;
    }

    private String unhide(String key) {
        return this.isHidden(key) ? key.substring(1) : key;
    }

    private boolean isHidden(String key) {
        return key != null && key.startsWith(".");
    }

    private void safeClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOG.warn("Error closing " + closeable.getClass() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

