/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.hdfs;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.EmptyResponse;
import org.apache.knox.gateway.shell.KnoxSession;

public class Rm {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) throws IOException {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        String file;
        Boolean recursive;

        Request(KnoxSession session) {
            super(session);
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        public Request recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Request recursive() {
            return this.recursive(true);
        }

        @Override
        public Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/webhdfs/v1", file});
                    this.addQueryParam(uri, "op", "DELETE");
                    this.addQueryParam(uri, "recursive", recursive);
                    HttpDelete request = new HttpDelete(uri.build());
                    return new Response((HttpResponse)this.execute((HttpRequest)request));
                }
            };
        }
    }
}

