/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.filter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public final class TimeFilter
extends Filter {
    private boolean acceptOnMatch = true;
    private long start = 0L;
    private long end = Long.MAX_VALUE;
    private Calendar calendar = Calendar.getInstance();
    private static final long HOUR_MS = 3600000L;
    private static final long MINUTE_MS = 60000L;
    private static final long SECOND_MS = 1000L;

    public void setStart(String s) {
        SimpleDateFormat stf = new SimpleDateFormat("HH:mm:ss");
        stf.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.start = stf.parse(s).getTime();
        }
        catch (ParseException ex) {
            LogLog.warn("Error parsing start value " + s, ex);
        }
    }

    public void setEnd(String s) {
        SimpleDateFormat stf = new SimpleDateFormat("HH:mm:ss");
        stf.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.end = stf.parse(s).getTime();
        }
        catch (ParseException ex) {
            LogLog.warn("Error parsing end value " + s, ex);
        }
    }

    public void setTimeZone(String s) {
        this.calendar = s == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(s));
    }

    public synchronized void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public synchronized boolean getAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public int decide(LoggingEvent event) {
        this.calendar.setTimeInMillis(event.timeStamp);
        long apparentOffset = (long)this.calendar.get(11) * 3600000L + (long)this.calendar.get(12) * 60000L + (long)this.calendar.get(13) * 1000L + (long)this.calendar.get(14);
        if (apparentOffset >= this.start && apparentOffset < this.end) {
            if (this.acceptOnMatch) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

