/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.appender;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="List")
public class ListAppender
extends AbstractAppender {
    final List<LogEvent> events = Collections.synchronizedList(new ArrayList());
    private final List<String> messages = Collections.synchronizedList(new ArrayList());
    final List<byte[]> data = Collections.synchronizedList(new ArrayList());
    private final boolean newLine;
    private final boolean raw;
    private static final String WINDOWS_LINE_SEP = "\r\n";
    public volatile CountDownLatch countDownLatch = null;

    public ListAppender(String name) {
        super(name, null, null, true, Property.EMPTY_ARRAY);
        this.newLine = false;
        this.raw = false;
    }

    public ListAppender(String name, Filter filter, Layout layout, boolean newline, boolean raw) {
        super(name, filter, layout, true, Property.EMPTY_ARRAY);
        byte[] bytes;
        this.newLine = newline;
        this.raw = raw;
        if (layout != null && (bytes = layout.getHeader()) != null) {
            this.write(bytes);
        }
    }

    public void append(LogEvent event) {
        Layout layout = this.getLayout();
        if (layout == null) {
            this.events.add(event.toImmutable());
        } else {
            this.write(layout.toByteArray(event));
        }
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    void write(byte[] bytes) {
        if (this.raw) {
            this.data.add(bytes);
            return;
        }
        String str = new String(bytes);
        if (this.newLine) {
            int index = 0;
            while (index < str.length()) {
                int length;
                int end;
                int wend = str.indexOf(WINDOWS_LINE_SEP, index);
                int lend = str.indexOf(10, index);
                if (wend >= 0 && wend < lend) {
                    end = wend;
                    length = 2;
                } else {
                    end = lend;
                    length = 1;
                }
                if (index == end) {
                    if (!this.messages.get(this.messages.size() - length).isEmpty()) {
                        this.messages.add("");
                    }
                } else {
                    if (end < 0) {
                        this.messages.add(str.substring(index));
                        break;
                    }
                    this.messages.add(str.substring(index, end));
                }
                index = end + length;
            }
        } else {
            this.messages.add(str);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        byte[] bytes;
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        Layout layout = this.getLayout();
        if (layout != null && (bytes = layout.getFooter()) != null) {
            this.write(bytes);
        }
        this.setStopped();
        return true;
    }

    public ListAppender clear() {
        this.events.clear();
        this.messages.clear();
        this.data.clear();
        return this;
    }

    public List<LogEvent> getEvents() {
        return Collections.unmodifiableList(new ArrayList<LogEvent>(this.events));
    }

    public List<String> getMessages() {
        return List.copyOf(this.messages);
    }

    public List<String> getMessages(int minSize, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long endMillis = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (this.messages.size() < minSize && System.currentTimeMillis() < endMillis) {
            Thread.sleep(100L);
        }
        return this.getMessages();
    }

    public List<byte[]> getData() {
        return List.copyOf(this.data);
    }

    public static ListAppender createAppender(String name, boolean newLine, boolean raw, Layout layout, Filter filter) {
        return new ListAppender(name, filter, layout, newLine, raw);
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static ListAppender getListAppender(String name) {
        return (ListAppender)LoggerContext.getContext((boolean)false).getConfiguration().getAppender(name);
    }

    public String toString() {
        return "ListAppender [events=" + this.events + ", messages=" + this.messages + ", data=" + this.data + ", newLine=" + this.newLine + ", raw=" + this.raw + ", countDownLatch=" + this.countDownLatch + ", getHandler()=" + this.getHandler() + ", getLayout()=" + this.getLayout() + ", getName()=" + this.getName() + ", ignoreExceptions()=" + this.ignoreExceptions() + ", getFilter()=" + this.getFilter() + ", getState()=" + this.getState() + "]";
    }

    public static class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<ListAppender> {
        private String name;
        private boolean entryPerNewLine;
        private boolean raw;
        private Layout layout;
        private Filter filter;

        public Builder setName(@Required @PluginAttribute String name) {
            this.name = name;
            return this;
        }

        public Builder setEntryPerNewLine(@PluginAttribute boolean entryPerNewLine) {
            this.entryPerNewLine = entryPerNewLine;
            return this;
        }

        public Builder setRaw(@PluginAttribute boolean raw) {
            this.raw = raw;
            return this;
        }

        public Builder setLayout(@PluginElement Layout layout) {
            this.layout = layout;
            return this;
        }

        public Builder setFilter(@PluginElement Filter filter) {
            this.filter = filter;
            return this;
        }

        public ListAppender build() {
            return new ListAppender(this.name, this.filter, this.layout, this.entryPerNewLine, this.raw);
        }
    }
}

