/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;

final class GcPressureGenerator
implements AutoCloseable {
    private final AtomicInteger sink = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final CountDownLatch stopLatch = new CountDownLatch(1);

    private GcPressureGenerator() {
        this.startGeneratorThread();
    }

    private void startGeneratorThread() {
        String threadName = GcPressureGenerator.class.getSimpleName();
        Thread thread = new Thread(this::generateGarbage, threadName);
        thread.setDaemon(true);
        thread.start();
    }

    private void generateGarbage() {
        try {
            while (this.running.get()) {
                byte[] object = new byte[0x100000];
                int positiveValue = Math.abs(object.hashCode());
                this.sink.set(positiveValue);
                System.gc();
                System.runFinalization();
            }
        }
        finally {
            this.stopLatch.countDown();
        }
    }

    static GcPressureGenerator ofStarted() {
        return new GcPressureGenerator();
    }

    @Override
    public void close() {
        boolean signalled = this.running.compareAndSet(true, false);
        if (signalled) {
            try {
                boolean stopped = this.stopLatch.await(10L, TimeUnit.SECONDS);
                Assertions.assertThat((boolean)stopped).isTrue();
                Assertions.assertThat((int)this.sink.get()).isPositive();
            }
            catch (InterruptedException error) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(error);
            }
        }
    }
}

