﻿using Lucene.Net.Analysis.Util;
using Lucene.Net.Util;
using System;
using System.Collections.Generic;
using System.IO;

namespace Lucene.Net.Analysis.Standard
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    /// <summary>
    /// Factory for <see cref="UAX29URLEmailTokenizer"/>. 
    /// <code>
    /// &lt;fieldType name="text_urlemail" class="solr.TextField" positionIncrementGap="100"&gt;
    ///   &lt;analyzer&gt;
    ///     &lt;tokenizer class="solr.UAX29URLEmailTokenizerFactory" maxTokenLength="255"/&gt;
    ///   &lt;/analyzer&gt;
    /// &lt;/fieldType&gt;</code> 
    /// </summary>
    public class UAX29URLEmailTokenizerFactory : TokenizerFactory
    {
        private readonly int maxTokenLength;

        /// <summary>
        /// Creates a new <see cref="UAX29URLEmailTokenizerFactory"/> </summary>
        public UAX29URLEmailTokenizerFactory(IDictionary<string, string> args)
            : base(args)
        {
            AssureMatchVersion();
            maxTokenLength = GetInt32(args, "maxTokenLength", StandardAnalyzer.DEFAULT_MAX_TOKEN_LENGTH);
            if (args.Count > 0)
            {
                throw new ArgumentException("Unknown parameters: " + args);
            }
        }

        public override Tokenizer Create(AttributeSource.AttributeFactory factory, TextReader input)
        {
            UAX29URLEmailTokenizer tokenizer = new UAX29URLEmailTokenizer(m_luceneMatchVersion, factory, input);
            tokenizer.MaxTokenLength = maxTokenLength;
            return tokenizer;
        }
    }
}