/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.openpgp;

import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableSet;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryDataResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.bouncycastle.openpgp.PGPPublicKey;

public class PGPPublicKeyEntryDataResolver
implements PublicKeyEntryDataResolver {
    public static final String PGP_RSA_KEY = "pgp-sign-rsa";
    public static final String PGP_DSS_KEY = "pgp-sign-dss";
    public static final NavigableSet<String> PGP_KEY_TYPES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[]{"pgp-sign-rsa", "pgp-sign-dss"}));
    public static final PGPPublicKeyEntryDataResolver DEFAULT = new PGPPublicKeyEntryDataResolver();

    public byte[] decodeEntryKeyData(String encData) {
        return PGPPublicKeyEntryDataResolver.decodeKeyFingerprint(encData);
    }

    public String encodeEntryKeyData(byte[] keyData) {
        return PGPPublicKeyEntryDataResolver.encodeKeyFingerprint(keyData);
    }

    public static byte[] decodeKeyFingerprint(String encData) {
        if (GenericUtils.isEmpty((CharSequence)encData)) {
            return GenericUtils.EMPTY_BYTE_ARRAY;
        }
        return BufferUtils.decodeHex((char)'\u0000', (CharSequence)encData);
    }

    public static String encodeKeyFingerprint(byte[] keyData) {
        if (NumberUtils.isEmpty((byte[])keyData)) {
            return "";
        }
        return BufferUtils.toHex((char)'\u0000', (byte[])keyData).toUpperCase();
    }

    public static void registerDefaultKeyEntryDataResolvers() {
        for (String keyType : PGP_KEY_TYPES) {
            PublicKeyEntry.registerKeyDataEntryResolver((String)keyType, (PublicKeyEntryDataResolver)DEFAULT);
        }
    }

    public static String getKeyType(PGPPublicKey key) {
        int algo = key == null ? -1 : key.getAlgorithm();
        switch (algo) {
            case 1: 
            case 2: 
            case 3: {
                return PGP_RSA_KEY;
            }
            case 17: {
                return PGP_DSS_KEY;
            }
        }
        return null;
    }
}

