/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.cert;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.security.cert.CertificateAttributeReader;
import org.apache.nifi.security.cert.GeneralNameType;
import org.apache.nifi.security.cert.StandardSubjectAlternativeName;
import org.apache.nifi.security.cert.SubjectAlternativeName;

public class StandardCertificateAttributeReader
implements CertificateAttributeReader {
    private static final int NAME_TYPE_INDEX = 0;
    private static final int NAME_INDEX = 1;
    private static final int NAME_TYPE_UNKNOWN = 0;

    @Override
    public List<SubjectAlternativeName> getSubjectAlternativeNames(X509Certificate certificate) {
        Objects.requireNonNull(certificate, "Certificate required");
        ArrayList<SubjectAlternativeName> names = new ArrayList<SubjectAlternativeName>();
        Collection<List<?>> subjectAlternativeNames = this.readSubjectAlternativeNames(certificate);
        for (List<?> subjectAlternativeTypeName : subjectAlternativeNames) {
            Object nameType = subjectAlternativeTypeName.get(0);
            GeneralNameType generalNameType = this.getGeneralNameType(nameType);
            Object name = subjectAlternativeTypeName.get(1);
            StandardSubjectAlternativeName subjectAlternativeName = name instanceof byte[] ? new StandardSubjectAlternativeName(generalNameType, (byte[])name) : new StandardSubjectAlternativeName(generalNameType, name.toString());
            names.add(subjectAlternativeName);
        }
        return names;
    }

    private Collection<List<?>> readSubjectAlternativeNames(X509Certificate certificate) {
        try {
            Collection<List<?>> names = certificate.getSubjectAlternativeNames();
            return names == null ? Collections.emptyList() : names;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    private GeneralNameType getGeneralNameType(Object nameType) {
        GeneralNameType generalNameTypeFound = GeneralNameType.OTHER_NAME;
        int resolvedNameType = this.getResolvedNameType(nameType);
        for (GeneralNameType generalNameType : GeneralNameType.values()) {
            if (generalNameType.getNameType() != resolvedNameType) continue;
            generalNameTypeFound = generalNameType;
            break;
        }
        return generalNameTypeFound;
    }

    private int getResolvedNameType(Object nameType) {
        int resolvedNameType = nameType instanceof Integer ? (Integer)nameType : 0;
        return resolvedNameType;
    }
}

