/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.lock;

import com.google.common.util.concurrent.RateLimiter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.asteriskjava.lock.Lockable;
import org.asteriskjava.pbx.util.LogTime;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class Locker {
    private static final Log logger = LogFactory.getLog(Locker.class);
    private static volatile boolean diags = false;
    private static ScheduledFuture<?> future;
    private static final ScheduledExecutorService executor;
    private static final Object sync;
    private static final Map<Long, Lockable> keepList;
    private static final RateLimiter waitRateLimiter;
    private static RateLimiter warnRateLimiter;
    private static final LogTime startTime;
    private static volatile boolean first;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockCloser doWithLock(Lockable lockable) {
        try {
            if (diags) {
                Object object = sync;
                synchronized (object) {
                    keepList.put(lockable.getLockableId(), lockable);
                }
                return Locker.lockWithDiags(lockable);
            }
            return Locker.simpleLock(lockable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getCaller(Lockable lockable) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        String name = lockable.getClass().getCanonicalName();
        for (StackTraceElement element : trace) {
            if (element.getFileName() == null || element.getFileName().contains(Locker.class.getSimpleName())) continue;
            name = element.getFileName() + " " + element.getMethodName() + " " + element.getLineNumber() + " " + element.getClassName();
            break;
        }
        return name;
    }

    private static LockCloser simpleLock(Lockable lockable) throws InterruptedException {
        LogTime acquireTimer = new LogTime();
        ReentrantLock lock = lockable.getInternalLock();
        lock.lock();
        if (acquireTimer.timeTaken() > 1000L && warnRateLimiter.tryAcquire()) {
            logger.warn("Locks are being held for to long, waited " + acquireTimer.timeTaken() + "ms, you can enable lock diagnostics by calling Locker.enable()");
        }
        LogTime holdTimer = new LogTime();
        return () -> {
            lock.unlock();
            if (holdTimer.timeTaken() > 500L && warnRateLimiter.tryAcquire() && startTime.timeTaken() > 10000L) {
                logger.warn("Locks are being held for to long (" + holdTimer.timeTaken() + "ms), you can enable lock diagnostics by calling Locker.enable()");
            }
        };
    }

    private static LockCloser lockWithDiags(final Lockable lockable) throws InterruptedException {
        final int offset = lockable.addLockRequested();
        final long waitStart = System.currentTimeMillis();
        final ReentrantLock lock = lockable.getInternalLock();
        while (!lock.tryLock(100L, TimeUnit.MILLISECONDS)) {
            if (!lockable.isLockDumped() && lockable.getDumpRateLimit().tryAcquire()) {
                lockable.setLockDumped(true);
                Locker.dumpThread(lockable.threadHoldingLock.get(), "Waiting on lock... blocked by... id:" + lockable.getLockableId());
            } else if (waitRateLimiter.tryAcquire()) {
                long elapsed = System.currentTimeMillis() - waitStart;
                logger.warn("waiting " + elapsed + "(MS) id:" + lockable.getLockableId());
            }
            lockable.setLockBlocked(true);
        }
        lockable.setLockDumped(false);
        lockable.addLockAcquired(1);
        final long acquiredAt = System.currentTimeMillis();
        lockable.threadHoldingLock.set(Thread.currentThread());
        return new LockCloser(){

            @Override
            public void close() {
                Exception trace;
                String message;
                long waiters = lockable.getLockRequested() - offset;
                lockable.addLockWaited((int)waiters);
                boolean dumped = lockable.isLockDumped();
                lock.unlock();
                int holdTime = (int)(System.currentTimeMillis() - acquiredAt);
                int waitTime = (int)(acquiredAt - waitStart);
                lockable.addLockTotalWaitTime(waitTime);
                lockable.addLockTotalHoldTime(holdTime);
                long averageHoldTime = lockable.getLockAverageHoldTime();
                if (waiters > 0L && (long)holdTime > averageHoldTime * 2L || dumped) {
                    message = "Lock held for (" + holdTime + "MS), " + waiters + " threads waited for some of that time! " + Locker.getCaller(lockable) + " id:" + lockable.getLockableId();
                    logger.warn(message);
                    if ((double)holdTime > (double)averageHoldTime * 10.0 || dumped) {
                        trace = new Exception(message);
                        logger.error(trace, trace);
                    }
                }
                if ((double)holdTime > (double)averageHoldTime * 5.0) {
                    message = "Lock hold of lock (" + holdTime + "MS), average is " + lockable.getLockAverageHoldTime() + " " + Locker.getCaller(lockable) + " id:" + lockable.getLockableId();
                    logger.warn(message);
                    if ((double)holdTime > (double)averageHoldTime * 10.0) {
                        trace = new Exception(message);
                        logger.error(trace, trace);
                    }
                }
            }
        };
    }

    public static void dumpThread(Thread thread, String message) {
        if (thread != null) {
            StackTraceElement[] trace = thread.getStackTrace();
            String dump = "";
            for (int i = 0; i < trace.length; ++i) {
                StackTraceElement ste = trace[i];
                dump = dump + "\tat " + ste.toString();
                dump = dump + '\n';
            }
            logger.error(message);
            if (dump.length() > 0) {
                logger.error(dump);
            } else {
                logger.error("Unable to create dump, thread seems to have exited.");
            }
        } else {
            logger.error("Thread hasn't been set: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enable() {
        Object object = sync;
        synchronized (object) {
            if (!diags) {
                diags = true;
                future = executor.scheduleWithFixedDelay(() -> Locker.dumpStats(), 1L, 1L, TimeUnit.MINUTES);
                logger.warn("Lock checking enabled");
            } else {
                logger.warn("Already enabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disable() {
        Object object = sync;
        synchronized (object) {
            if (diags) {
                diags = false;
                future.cancel(false);
                Locker.dumpStats();
                logger.warn("Lock checking disabled");
            } else {
                logger.warn("Lock checking is already disabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpStats() {
        LinkedList<Lockable> lockables = new LinkedList<Lockable>();
        Object object = sync;
        synchronized (object) {
            lockables.addAll(keepList.values());
            keepList.clear();
        }
        boolean activity = false;
        for (Lockable lockable : lockables) {
            if (!lockable.wasLockBlocked()) continue;
            int waited = lockable.getLockWaited();
            int waitTime = lockable.getLockTotalWaitTime();
            int acquired = lockable.getLockAcquired();
            int holdTime = lockable.getLockTotalHoldTime();
            lockable.setLockBlocked(false);
            activity = true;
            logger.warn(lockable.asLockString());
            lockable.addLockWaited(-waited);
            lockable.addLockTotalWaitTime(-waitTime);
            lockable.addLockAcquired(-acquired);
            lockable.addLockTotalHoldTime(-holdTime);
        }
        if (first || activity) {
            logger.warn("Will dump Lock stats each minute when there is contention...");
            first = false;
        }
    }

    static {
        executor = Executors.newSingleThreadScheduledExecutor();
        sync = new Object();
        keepList = new HashMap<Long, Lockable>();
        waitRateLimiter = RateLimiter.create((double)4.0);
        warnRateLimiter = RateLimiter.create((double)0.1);
        startTime = new LogTime();
        first = true;
    }

    public static interface LockCloser
    extends AutoCloseable {
        @Override
        public void close();
    }
}

