/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.memory.AccumulationLimitExceededException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class HashJoinCollectP<K, T, V>
extends AbstractProcessor {
    private static final BinaryOperator<Object> MERGE_FN = (o, n) -> {
        if (o instanceof HashJoinArrayList) {
            HashJoinArrayList list = (HashJoinArrayList)o;
            list.add(n);
            return o;
        }
        HashJoinArrayList res = new HashJoinArrayList();
        res.add(o);
        res.add(n);
        return res;
    };
    private final Map<K, Object> lookupTable = new HashMap<K, Object>();
    private final Function<T, K> keyFn;
    private final Function<T, V> projectFn;
    private long maxEntries;
    private long numberOfEntries;

    public HashJoinCollectP(@Nonnull Function<T, K> keyFn, @Nonnull Function<T, V> projectFn) {
        this.keyFn = keyFn;
        this.projectFn = projectFn;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.maxEntries = context.maxProcessorAccumulatedRecords();
    }

    @Override
    protected boolean tryProcess0(@Nonnull Object item) {
        if (this.numberOfEntries == this.maxEntries) {
            throw new AccumulationLimitExceededException();
        }
        Object t = item;
        K key = this.keyFn.apply(t);
        V value = this.projectFn.apply(t);
        this.lookupTable.merge(key, value, MERGE_FN);
        ++this.numberOfEntries;
        return true;
    }

    @Override
    public boolean complete() {
        return this.tryEmit(this.lookupTable);
    }

    @Override
    public boolean closeIsCooperative() {
        return true;
    }

    static final class HashJoinArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        HashJoinArrayList() {
            super(2);
        }
    }
}

