/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.container.SerializableBeanVault;
import org.apache.webbeans.context.creational.BeanInstanceBag;

public abstract class AbstractContext
implements AlterableContext,
Serializable {
    private static final long serialVersionUID = 2357678967444477818L;
    protected volatile boolean active;
    protected Map<Contextual<?>, BeanInstanceBag<?>> componentInstanceMap = null;
    protected Class<? extends Annotation> scopeType;

    private <T> BeanInstanceBag<T> createContextualBag(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        BeanInstanceBag<T> bag = new BeanInstanceBag<T>(creationalContext);
        if (this.componentInstanceMap instanceof ConcurrentMap) {
            BeanInstanceBag<T> existingBag = ((ConcurrentMap)this.componentInstanceMap).putIfAbsent(contextual, bag);
            if (existingBag != null) {
                bag = existingBag;
            }
        } else {
            this.componentInstanceMap.put(contextual, bag);
        }
        return bag;
    }

    protected AbstractContext(Class<? extends Annotation> scopeType) {
        this.scopeType = scopeType;
        this.setComponentInstanceMap();
    }

    public <T> T get(Contextual<T> component) {
        this.checkActive();
        BeanInstanceBag<?> bag = this.componentInstanceMap.get(component);
        if (bag != null) {
            return (T)bag.getBeanInstance();
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        this.checkActive();
        return this.getInstance(contextual, creationalContext);
    }

    protected <T> T getInstance(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Object instance;
        BeanInstanceBag<Object> bag = this.componentInstanceMap.get(contextual);
        if (bag == null) {
            bag = this.createContextualBag(contextual, creationalContext);
        }
        if ((instance = bag.getBeanInstance()) != null) {
            return (T)instance;
        }
        if (creationalContext == null) {
            return null;
        }
        instance = bag.create(contextual);
        return (T)instance;
    }

    public void destroy(Contextual<?> contextual) {
        this.destroyInstance(contextual);
    }

    public void destroyInstance(Contextual<?> contextual) {
        BeanInstanceBag<?> instance = this.componentInstanceMap.get(contextual);
        if (instance == null) {
            return;
        }
        CreationalContext<?> cc = instance.getBeanCreationalContext();
        Object beanInstance = instance.getBeanInstance();
        if (beanInstance != null) {
            this.destroyInstance(contextual, beanInstance, cc);
        }
    }

    private <T> void destroyInstance(Contextual<T> component, T instance, CreationalContext<T> creationalContext) {
        component.destroy(instance, creationalContext);
        this.componentInstanceMap.remove(component);
    }

    public void destroy() {
        HashSet keySet = new HashSet(this.componentInstanceMap.keySet());
        for (Contextual contextual : keySet) {
            this.destroyInstance(contextual);
        }
        this.setActive(false);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    protected abstract void setComponentInstanceMap();

    protected void checkActive() {
        if (!this.active) {
            throw new ContextNotActiveException("WebBeans context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.scopeType);
        if (this.componentInstanceMap != null) {
            SerializableBeanVault sbv = WebBeansContext.getInstance().getSerializableBeanVault();
            HashMap serializableInstanceMap = new HashMap();
            for (Map.Entry<Contextual<?>, BeanInstanceBag<?>> componentInstanceMapEntry : this.componentInstanceMap.entrySet()) {
                serializableInstanceMap.put(sbv.getSerializableBean(componentInstanceMapEntry.getKey()), componentInstanceMapEntry.getValue());
            }
            s.writeObject(serializableInstanceMap);
        } else {
            s.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.scopeType = (Class)s.readObject();
        HashMap serializableInstanceMap = (HashMap)s.readObject();
        if (serializableInstanceMap != null) {
            this.setComponentInstanceMap();
            if (this.componentInstanceMap == null) {
                throw new NotSerializableException("componentInstanceMap not initialized!");
            }
            for (Map.Entry serializableInstanceMapEntry : serializableInstanceMap.entrySet()) {
                Contextual bean = (Contextual)serializableInstanceMapEntry.getKey();
                if (bean instanceof SerializableBean) {
                    this.componentInstanceMap.put((Contextual<?>)((SerializableBean)bean).getBean(), (BeanInstanceBag<?>)serializableInstanceMapEntry.getValue());
                    continue;
                }
                this.componentInstanceMap.put((Contextual<?>)bean, (BeanInstanceBag<?>)serializableInstanceMapEntry.getValue());
            }
        }
    }
}

